/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrEncodingStream;

public class XdrTcpChannelEncodingStream
extends XdrEncodingStream {
    private SocketChannel tcpChannel;
    private ByteBuffer byteBuffer;
    private static final int BUFFER_SIZE_MIN = 1024;
    private static final int ALIGNMENT = 4;
    private static final int ALIGNMENT_MOD = 3;
    private static final int FRAGMENT_HEADER_LENGTH = 4;
    private static final byte[] PADDING_ZEROS = XdrTcpChannelEncodingStream.getPaddingZeros();

    public XdrTcpChannelEncodingStream(SocketChannel tcpChannel, int bufferSize) {
        this.tcpChannel = tcpChannel;
        if (bufferSize < 1024) {
            bufferSize = 1024;
        } else if ((bufferSize & 3) != 0) {
            bufferSize = bufferSize + 4 & 0xFFFFFFFC;
        }
        this.byteBuffer = ByteBuffer.allocate(bufferSize);
    }

    @Override
    public void beginEncoding(InetAddress receiverAddress, int receiverPort) throws OncRpcException, IOException {
        this.byteBuffer.mark().position(this.byteBuffer.position() + 4);
    }

    @Override
    public void endEncoding() throws OncRpcException, IOException {
        int lastPosition = this.byteBuffer.position();
        this.byteBuffer.reset();
        this.byteBuffer.putInt(lastPosition - this.byteBuffer.position() - 4 | Integer.MIN_VALUE);
        this.flush();
    }

    @Override
    public void xdrEncodeInt(int value) throws OncRpcException, IOException {
        if (this.byteBuffer.remaining() < 4) {
            this.flushFragment();
        }
        this.byteBuffer.putInt(value);
    }

    @Override
    public void xdrEncodeOpaque(byte[] value, int offset, int length) throws OncRpcException, IOException {
        if (value != null && offset + length <= value.length) {
            int availableSpace = this.byteBuffer.remaining();
            while (length > availableSpace) {
                this.byteBuffer.put(value, offset, availableSpace);
                length -= availableSpace;
                offset += availableSpace;
                this.flushFragment();
                availableSpace = this.byteBuffer.remaining();
            }
            if (length > 0) {
                int padding = 4 - (length & 3) & 3;
                this.byteBuffer.put(value, offset, length);
                if (padding > 0) {
                    this.byteBuffer.put(PADDING_ZEROS, 0, padding);
                }
            }
        } else {
            throw new OncRpcException(1);
        }
    }

    private void flushFragment() throws IOException {
        int lastPosition = this.byteBuffer.position();
        this.byteBuffer.reset();
        this.byteBuffer.putInt(lastPosition - this.byteBuffer.position() - 4);
        this.flush();
        this.byteBuffer.mark().position(this.byteBuffer.position() + 4);
    }

    private void flush() throws IOException {
        this.byteBuffer.flip();
        this.tcpChannel.write(this.byteBuffer);
        this.byteBuffer.rewind();
    }

    private static byte[] getPaddingZeros() {
        byte[] paddingZeros = new byte[4];
        for (int index = 0; index < 4; ++index) {
            paddingZeros[index] = 0;
        }
        return paddingZeros;
    }
}

