/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrEncodingStream;

public class XdrHashCode
extends XdrEncodingStream {
    static final int prime = 31;
    protected int result = 31;

    @Override
    public void xdrEncodeInt(int value) throws OncRpcException, IOException {
        this.result = 31 * this.result + value;
    }

    @Override
    public void xdrEncodeOpaque(byte[] value, int offset, int length) throws OncRpcException, IOException {
        for (int i = offset; i < length; ++i) {
            this.result = 31 * this.result + value[i];
        }
    }

    public int getResult() {
        return this.result;
    }

    public static int hashCode(XdrAble xa) {
        XdrHashCode xhc = new XdrHashCode();
        try {
            xa.xdrEncode(xhc);
            return xhc.result;
        }
        catch (IOException | OncRpcException e) {
            return 42;
        }
    }
}

