/*
 * Decompiled with CFR 0.152.
 */
package com.munts.libsimpleio;

import com.munts.interfaces.Watchdog.Timer;
import com.munts.libsimpleio.bindings.libwatchdog;
import com.munts.libsimpleio.errno;
import com.sun.jna.ptr.IntByReference;

public final class Watchdog {
    private Watchdog() {
    }

    public static Timer Create(String string, int n) {
        return new TimerSubclass(string, n);
    }

    public static Timer Create(String string) {
        return new TimerSubclass(string, 0);
    }

    public static Timer Create() {
        return new TimerSubclass("/dev/watchdog", 0);
    }

    private static class TimerSubclass
    implements Timer {
        int fd;

        TimerSubclass(String string, int n) {
            IntByReference intByReference = new IntByReference();
            IntByReference intByReference2 = new IntByReference();
            IntByReference intByReference3 = new IntByReference();
            libwatchdog.WATCHDOG_open(string, intByReference, intByReference2);
            if (intByReference2.getValue() != 0) {
                throw new RuntimeException("ERROR: WATCHDOG_open() failed, " + errno.strerror(intByReference2.getValue()));
            }
            this.fd = intByReference.getValue();
            if (n == 0) {
                return;
            }
            libwatchdog.WATCHDOG_set_timeout(this.fd, n, intByReference3, intByReference2);
            if (intByReference2.getValue() != 0) {
                throw new RuntimeException("ERROR: WATCHDOG_set_timeout() failed, " + errno.strerror(intByReference2.getValue()));
            }
        }

        @Override
        public int GetTimeout() {
            IntByReference intByReference = new IntByReference();
            IntByReference intByReference2 = new IntByReference();
            libwatchdog.WATCHDOG_get_timeout(this.fd, intByReference, intByReference2);
            if (intByReference2.getValue() != 0) {
                throw new RuntimeException("ERROR: WATCHDOG_get_timeout() failed, " + errno.strerror(intByReference2.getValue()));
            }
            return intByReference.getValue();
        }

        @Override
        public void SetTimeout(int n) {
            IntByReference intByReference = new IntByReference();
            IntByReference intByReference2 = new IntByReference();
            libwatchdog.WATCHDOG_set_timeout(this.fd, n, intByReference, intByReference2);
            if (intByReference2.getValue() != 0) {
                throw new RuntimeException("ERROR: WATCHDOG_set_timeout() failed, " + errno.strerror(intByReference2.getValue()));
            }
        }

        @Override
        public void Kick() {
            IntByReference intByReference = new IntByReference();
            libwatchdog.WATCHDOG_kick(this.fd, intByReference);
            if (intByReference.getValue() != 0) {
                throw new RuntimeException("ERROR: WATCHDOG_kick() failed, " + errno.strerror(intByReference.getValue()));
            }
        }

        public void finalize() {
            IntByReference intByReference = new IntByReference();
            libwatchdog.WATCHDOG_close(this.fd, intByReference);
            this.fd = -1;
        }
    }
}

