/*
 * Decompiled with CFR 0.152.
 */
package com.munts.libsimpleio;

import com.munts.interfaces.PWM.Output;
import com.munts.libsimpleio.Designator;
import com.munts.libsimpleio.bindings.libpwm;
import com.munts.libsimpleio.errno;
import com.sun.jna.ptr.IntByReference;

public final class PWM {
    private PWM() {
    }

    public static Output Create(Designator designator, int n, double d, Polarity polarity) {
        return new OutputSubclass(designator, n, d, polarity);
    }

    public static Output Create(Designator designator, int n, double d) {
        return new OutputSubclass(designator, n, d, Polarity.ActiveHigh);
    }

    public static Output Create(Designator designator, int n) {
        return new OutputSubclass(designator, n, 0.0, Polarity.ActiveHigh);
    }

    private static class OutputSubclass
    implements Output {
        int fd;
        int period;

        OutputSubclass(Designator designator, int n, double d, Polarity polarity) {
            IntByReference intByReference = new IntByReference();
            IntByReference intByReference2 = new IntByReference();
            if (n < 1) {
                throw new RuntimeException("ERROR: frequency is invalid");
            }
            if (d < 0.0 || d > 100.0) {
                throw new RuntimeException("ERROR: Invalid duty cycle parameter");
            }
            if (polarity.ordinal() < 0 || polarity.ordinal() > 1) {
                throw new RuntimeException("ERROR: Invalid polarity parameter");
            }
            this.period = (int)Math.round(1.0E9 / (double)n);
            int n2 = (int)Math.round(d / 100.0 * (double)this.period);
            libpwm.PWM_configure(designator.chip(), designator.channel(), this.period, n2, polarity.ordinal(), intByReference2);
            if (intByReference2.getValue() != 0) {
                throw new RuntimeException("ERROR: PWM_configure() failed, " + errno.strerror(intByReference2.getValue()));
            }
            libpwm.PWM_open(designator.chip(), designator.channel(), intByReference, intByReference2);
            if (intByReference2.getValue() != 0) {
                throw new RuntimeException("ERROR: PWM_open() failed, " + errno.strerror(intByReference2.getValue()));
            }
            this.fd = intByReference.getValue();
        }

        @Override
        public void write(double d) {
            IntByReference intByReference = new IntByReference();
            int n = (int)Math.round(d / 100.0 * (double)this.period);
            libpwm.PWM_write(this.fd, n, intByReference);
            if (intByReference.getValue() != 0) {
                throw new RuntimeException("ERROR: PWM_write() failed, " + errno.strerror(intByReference.getValue()));
            }
        }

        public void finalize() {
            IntByReference intByReference = new IntByReference();
            libpwm.PWM_close(this.fd, intByReference);
            this.fd = -1;
        }
    }

    public static enum Polarity {
        ActiveLow,
        ActiveHigh;

    }
}

