/*
 * Decompiled with CFR 0.152.
 */
package com.munts.libsimpleio.GPIO;

import com.munts.interfaces.GPIO.Pin;
import com.munts.libsimpleio.GPIO.Builder;
import com.munts.libsimpleio.bindings.libgpio;
import com.munts.libsimpleio.errno;
import com.sun.jna.ptr.IntByReference;

public class PinSubclass
implements Pin {
    private int fd;
    private Kinds kind;

    public PinSubclass(Builder builder) {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        libgpio.GPIO_line_open(builder.chip, builder.line, builder.flags, builder.events, builder.state, intByReference2, intByReference);
        if (intByReference.getValue() != 0) {
            throw new RuntimeException("ERROR: GPIO_line_open() failed, " + errno.strerror(intByReference.getValue()));
        }
        this.fd = intByReference2.getValue();
        this.kind = (builder.flags & 2) != 0 ? Kinds.output : (builder.events == 0 ? Kinds.input : Kinds.interrupt);
    }

    @Override
    public boolean read() {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        if (this.kind == Kinds.interrupt) {
            libgpio.GPIO_line_event(this.fd, intByReference, intByReference2);
            if (intByReference2.getValue() != 0) {
                throw new RuntimeException("ERROR: GPIO_line_event() failed, " + errno.strerror(intByReference2.getValue()));
            }
        } else {
            libgpio.GPIO_line_read(this.fd, intByReference, intByReference2);
            if (intByReference2.getValue() != 0) {
                throw new RuntimeException("ERROR: GPIO_line_read() failed, " + errno.strerror(intByReference2.getValue()));
            }
        }
        return intByReference.getValue() == 1;
    }

    @Override
    public void write(boolean bl) {
        if (this.kind != Kinds.output) {
            throw new RuntimeException("ERROR: Cannot write to input pin");
        }
        IntByReference intByReference = new IntByReference();
        libgpio.GPIO_line_write(this.fd, bl ? 1 : 0, intByReference);
        if (intByReference.getValue() != 0) {
            throw new RuntimeException("ERROR: GPIO_line_write() failed, " + errno.strerror(intByReference.getValue()));
        }
    }

    public void finalize() {
        IntByReference intByReference = new IntByReference();
        libgpio.GPIO_line_close(this.fd, intByReference);
        if (intByReference.getValue() != 0) {
            throw new RuntimeException("ERROR: GPIO_line_close() failed, " + errno.strerror(intByReference.getValue()));
        }
        this.fd = -1;
    }

    private static enum Kinds {
        input,
        output,
        interrupt;

    }
}

