/*
 * Decompiled with CFR 0.152.
 */
package com.munts.libsimpleio.GPIO;

import com.munts.interfaces.GPIO.Direction;
import com.munts.interfaces.GPIO.Pin;
import com.munts.libsimpleio.Designator;
import com.munts.libsimpleio.GPIO.Driver;
import com.munts.libsimpleio.GPIO.Edge;
import com.munts.libsimpleio.GPIO.PinSubclass;
import com.munts.libsimpleio.GPIO.Polarity;

public class Builder {
    public int chip;
    public int line;
    public int flags;
    public int events;
    public int state;

    public Builder(Designator designator) {
        this.chip = designator.chip();
        this.line = designator.channel();
        this.flags = 0;
        this.events = 0;
        this.state = 0;
    }

    public void SetDirection(Direction direction) {
        switch (direction) {
            case Input: {
                this.flags |= 1;
                break;
            }
            case Output: {
                this.flags |= 2;
                break;
            }
            default: {
                throw new RuntimeException("ERROR: Invalid direction parameter");
            }
        }
    }

    public void SetDriver(Driver driver) {
        switch (driver) {
            case PushPull: {
                this.flags |= 0;
                break;
            }
            case OpenDrain: {
                this.flags |= 8;
                break;
            }
            case OpenSource: {
                this.flags |= 0x10;
                break;
            }
            default: {
                throw new RuntimeException("ERROR: Invalid driver parameter");
            }
        }
    }

    public void SetPolarity(Polarity polarity) {
        switch (polarity) {
            case ActiveLow: {
                this.flags |= 4;
                break;
            }
            case ActiveHigh: {
                this.flags |= 0;
                break;
            }
            default: {
                throw new RuntimeException("ERROR: Invalid polarity parameter");
            }
        }
    }

    public void SetInterrupt(Edge edge) {
        switch (edge) {
            case None: {
                this.events = 0;
                break;
            }
            case Rising: {
                this.events = 1;
                break;
            }
            case Falling: {
                this.events = 2;
                break;
            }
            case Both: {
                this.events = 3;
                break;
            }
            default: {
                throw new RuntimeException("ERROR: Invalid interrupt edge parameter");
            }
        }
    }

    public void SetState(boolean bl) {
        this.state = bl ? 1 : 0;
    }

    public Pin Create() {
        return new PinSubclass(this);
    }
}

