/*
 * Decompiled with CFR 0.152.
 */
package com.munts.libsimpleio;

import com.munts.interfaces.ADC.Input;
import com.munts.interfaces.ADC.Sample;
import com.munts.interfaces.ADC.Voltage;
import com.munts.libsimpleio.Designator;
import com.munts.libsimpleio.bindings.libadc;
import com.munts.libsimpleio.errno;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.IntByReference;

public final class ADC {
    private ADC() {
    }

    public static double Reference(Designator designator) {
        DoubleByReference doubleByReference = new DoubleByReference();
        IntByReference intByReference = new IntByReference();
        libadc.ADC_get_reference(designator.chip(), doubleByReference, intByReference);
        if (intByReference.getValue() != 0) {
            throw new RuntimeException("ERROR: ADC_get_reference() failed, " + errno.strerror(intByReference.getValue()));
        }
        return doubleByReference.getValue();
    }

    public static double ScaleFactor(Designator designator) {
        DoubleByReference doubleByReference = new DoubleByReference();
        IntByReference intByReference = new IntByReference();
        libadc.ADC_get_scale(designator.chip(), designator.channel(), doubleByReference, intByReference);
        if (intByReference.getValue() != 0) {
            throw new RuntimeException("ERROR: ADC_get_scale() failed, " + errno.strerror(intByReference.getValue()));
        }
        return doubleByReference.getValue();
    }

    public static Sample Create(Designator designator, int n) {
        return new SampleSubclass(designator, n);
    }

    public static Voltage Create(Designator designator, int n, double d, double d2) {
        return new Input(new SampleSubclass(designator, n), d, d2);
    }

    public static Voltage Create(Designator designator, int n, double d) {
        return new Input(new SampleSubclass(designator, n), ADC.Reference(designator), d);
    }

    public static Voltage Create(Designator designator, double d) {
        return new Input(new SampleSubclass(designator, 31), ADC.ScaleFactor(designator) * Math.pow(2.0, 31.0), d);
    }

    public static Voltage Create(Designator designator) {
        return new Input(new SampleSubclass(designator, 31), ADC.ScaleFactor(designator) * Math.pow(2.0, 31.0), 1.0);
    }

    private static class SampleSubclass
    implements Sample {
        int fd;
        int numbits;

        SampleSubclass(Designator designator, int n) {
            IntByReference intByReference = new IntByReference();
            IntByReference intByReference2 = new IntByReference();
            if (n < 1) {
                throw new RuntimeException("ERROR: resolution is invalid");
            }
            libadc.ADC_open(designator.chip(), designator.channel(), intByReference, intByReference2);
            if (intByReference2.getValue() != 0) {
                throw new RuntimeException("ERROR: ADC_open() failed, " + errno.strerror(intByReference2.getValue()));
            }
            this.fd = intByReference.getValue();
            this.numbits = n;
        }

        @Override
        public int read() {
            IntByReference intByReference = new IntByReference();
            IntByReference intByReference2 = new IntByReference();
            libadc.ADC_read(this.fd, intByReference, intByReference2);
            if (intByReference2.getValue() != 0) {
                throw new RuntimeException("ERROR: ADC_read() failed, " + errno.strerror(intByReference2.getValue()));
            }
            return intByReference.getValue();
        }

        @Override
        public int resolution() {
            return this.numbits;
        }

        public void finalize() {
            IntByReference intByReference = new IntByReference();
            libadc.ADC_close(this.fd, intByReference);
            this.fd = -1;
            this.numbits = -1;
        }
    }
}

