/*
 * Decompiled with CFR 0.152.
 */
package com.munts.interfaces.ADC;

import com.munts.interfaces.ADC.Sample;
import com.munts.interfaces.ADC.Voltage;

public class Input
implements Voltage {
    private Sample input;
    private double stepsize;
    private double gain;

    public Input(Sample sample, double d, double d2) {
        if (d == 0.0) {
            throw new RuntimeException("ERROR: reference is invalid");
        }
        if (d2 == 0.0) {
            throw new RuntimeException("ERROR: gain is invalid");
        }
        this.input = sample;
        this.stepsize = d / Math.pow(2.0, sample.resolution());
        this.gain = d2;
    }

    @Override
    public double voltage() {
        return (double)this.input.read() * this.stepsize / this.gain;
    }
}

