/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenConst;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenContext;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenItem;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenItemTable;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenJavaFile;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenProcedureInfo;

class JrpcgenVersionInfo
implements JrpcgenItem {
    public String versionNumber;
    public String resolvedVersionNumber;
    public String versionId;
    public JrpcgenProcedureInfo.Table procedures;
    private final JrpcgenContext context;
    private final List<JrpcgenConst> procedureConstants = new LinkedList<JrpcgenConst>();

    public JrpcgenVersionInfo(JrpcgenContext context, String versionId, String versionNumber, JrpcgenProcedureInfo.Table procedures) {
        this.versionId = versionId;
        this.versionNumber = versionNumber;
        this.procedures = procedures;
        this.context = context;
    }

    @Override
    public String getIdentifier() {
        return this.versionId;
    }

    public List<JrpcgenConst> getProcedureConstants() {
        return this.procedureConstants;
    }

    public JrpcgenProcedureInfo completeProcedureInfos() {
        JrpcgenProcedureInfo conflictingProcedure = null;
        if (this.resolvedVersionNumber != null && this.procedures != null) {
            Iterator procedureIterator = this.procedures.iterator();
            while (conflictingProcedure == null && procedureIterator.hasNext()) {
                JrpcgenProcedureInfo procedure = (JrpcgenProcedureInfo)procedureIterator.next();
                String procedureId = procedure.procedureId + "_" + this.resolvedVersionNumber;
                JrpcgenConst procedureConstant = new JrpcgenConst(this.context, procedureId, procedure.procedureNumber, this.context.options().baseClassname);
                procedure.procedureId = procedureId;
                if (!this.context.globalDefinitions().addItem(procedureConstant)) {
                    conflictingProcedure = procedure;
                    continue;
                }
                this.procedureConstants.add(procedureConstant);
                procedure.setConstant(procedureConstant);
            }
        }
        return conflictingProcedure;
    }

    public void writeClientStubMethods(JrpcgenJavaFile javaFile) {
        for (JrpcgenProcedureInfo procedure : this.procedures) {
            String argumentName = null;
            String resultName = "result$";
            procedure.writeClientStubSignature(javaFile.newLine());
            argumentName = procedure.writeXdrCallArgument(javaFile, this.context);
            procedure.writeXdrResultArgument(javaFile, resultName);
            if (this.context.options().clampProgAndVers) {
                javaFile.beginLine().append("client.call(").append(procedure.getConstant().getAsRValue(null)).append(", ").append(JrpcgenConst.getAsRValue(this.getIdentifier(), null, this.context)).append(", ").append(argumentName).append(", ").append(resultName).println(");");
            } else {
                javaFile.beginLine().append("client.call(").append(procedure.getConstant().getAsRValue(null)).append(", client.getVersion(), ").append(argumentName).append(", ").append(resultName).println(");");
            }
            procedure.writeReturnStatement(javaFile, resultName);
            javaFile.endBlock().println('}');
        }
    }

    public void writeServerStubMethodCalls(JrpcgenJavaFile javaFile) {
        boolean hasNullProcedure = false;
        Iterator<JrpcgenConst> procedureConstant = this.procedureConstants.iterator();
        while (!hasNullProcedure && procedureConstant.hasNext()) {
            hasNullProcedure = "0".equals(procedureConstant.next().resolveValue());
        }
        javaFile.beginBlock().println("switch ( procedure ) {");
        if (!hasNullProcedure) {
            javaFile.elseBlock().println("case 0:").beginLine().println("call.retrieveCall(XdrVoid.XDR_VOID);").beginLine().println("call.reply(XdrVoid.XDR_VOID);").beginLine().println("break;");
        }
        for (JrpcgenProcedureInfo procedure : this.procedures) {
            procedure.writeServerStubMethodCall(javaFile, this.context);
        }
        javaFile.elseBlock().println("default:").beginLine().println("call.failProcedureUnavailable();").endBlock().println('}');
    }

    public void writeServerStubMethods(JrpcgenJavaFile javaFile) {
        for (JrpcgenProcedureInfo procedure : this.procedures) {
            procedure.writeServerStubDeclaration(javaFile, this.context);
        }
    }

    public void dumpConstants(PrintWriter out) {
        out.println("    /* ONC/RPC program version number definition */");
        out.println("    public final static int " + this.versionId + " = " + this.versionNumber + ";");
    }

    public void dump() {
        this.dump(System.out).println();
    }

    public <T extends Appendable> T dump(T appendable) {
        try {
            appendable.append("VERSION ").append(this.versionId).append(" = ").append(this.versionNumber).append(JrpcgenContext.newline());
            for (JrpcgenProcedureInfo procedure : this.procedures) {
                procedure.dump(appendable.append("  ")).append(JrpcgenContext.newline());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return appendable;
    }

    public static class Table
    extends JrpcgenItemTable<JrpcgenVersionInfo> {
    }
}

