/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

import java.io.IOException;
import java.util.Objects;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenConst;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenContext;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenDeclaration;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenJavaFile;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenSHA;

public class JrpcgenUnionArm {
    public String value;
    public JrpcgenDeclaration element;

    public JrpcgenUnionArm(String value, JrpcgenDeclaration element) {
        this.value = value;
        this.element = element;
    }

    public boolean mapsToFollowingArm() {
        return this.element == null;
    }

    public boolean isDefaultArm() {
        return this.value == null;
    }

    public boolean hasVoidType() {
        return this.element != null && this.element.getTypeMapping().isVoid();
    }

    public boolean hasPayload() {
        return this.element != null && !this.element.getTypeMapping().isVoid();
    }

    public void updateHash(JrpcgenSHA hash) {
        if (this.hasPayload()) {
            if (this.isDefaultArm()) {
                hash.update("default");
            } else {
                hash.update(this.value);
            }
            this.element.updateHash(hash);
        }
    }

    public void writeMemberDeclaration(JrpcgenJavaFile javaFile, String access, boolean initString) {
        if (this.hasPayload()) {
            this.element.writeMemberDeclaration(javaFile, access, initString);
        }
    }

    public void startCase(JrpcgenJavaFile javaFile, String enclosure, JrpcgenContext context) {
        if (this.isDefaultArm()) {
            javaFile.elseBlock().println("default:");
        } else {
            javaFile.elseBlock().append("case ").append(JrpcgenConst.getAsCaseValue(this.value, enclosure, context)).println(':');
        }
    }

    public void endCase(JrpcgenJavaFile javaFile) {
        if (!this.mapsToFollowingArm()) {
            javaFile.beginLine().println("break;");
        }
    }

    public void writeConstructorArm(JrpcgenJavaFile javaFile, String valueName, JrpcgenContext context) {
        if (this.hasPayload()) {
            javaFile.beginLine().append("this.").append(this.element.getIdentifier()).append(" = ");
            if (this.element.isArray()) {
                javaFile.leftParenthesis().append(this.element.getTypeMapping().getJavaName()).append("[])").append(valueName);
            } else if (this.element.getTypeMapping().isStringType() || !this.element.getTypeMapping().isBaseType()) {
                javaFile.leftParenthesis().append(this.element.getTypeMapping().getJavaName()).rightParenthesis().append(valueName);
            } else if (this.element.getTypeMapping().isBooleanType()) {
                javaFile.append("((Boolean)").append(valueName).append(").booleanValue()");
            } else {
                javaFile.append("((Number)").append(valueName).append(").").append(this.element.getTypeMapping().getJavaName()).append("Value()");
            }
            javaFile.println(';');
        }
    }

    public void writeEncodingPart(JrpcgenJavaFile javaFile, String enclosure, JrpcgenContext context) {
        if (this.hasPayload()) {
            this.element.writeEncodingPart(javaFile, enclosure, context);
        }
    }

    public void writeDecodingPart(JrpcgenJavaFile javaFile, String enclosure, JrpcgenContext context) {
        if (this.hasPayload()) {
            this.element.writeDecodingPart(javaFile, enclosure, context);
        }
    }

    public void writeToStringPart(JrpcgenJavaFile javaFile, JrpcgenContext context) {
        if (this.hasPayload()) {
            javaFile.beginLine().append("ret += ");
            if (this.element.isArray()) {
                javaFile.append("java.util.Arrays.toString(this.").append(this.element.getIdentifier());
            } else {
                javaFile.append("this.").append(this.element.getIdentifier());
            }
            javaFile.append(";").newLine();
        }
    }

    public void writeEqualsPart(JrpcgenJavaFile javaFile, JrpcgenContext context) {
        if (this.hasPayload()) {
            javaFile.beginLine().append("ret = ");
            this.element.writeEqualsExpression(javaFile, false, context);
            javaFile.println(";");
        }
    }

    public String toString() {
        String armValue;
        String armAsString = "";
        String string = armValue = this.value != null ? this.value : "default";
        armAsString = this.element == null ? "  " + armValue + ": -" : (this.element.getIdentifier() != null ? "  " + armValue + ": " + Objects.toString(this.element) : "  " + armValue + ": void");
        return armAsString;
    }

    public void dump() {
        this.dump(System.out).println();
    }

    public <T extends Appendable> T dump(T appendable) {
        try {
            appendable.append(this.value != null ? this.value : "default");
            if (this.element == null) {
                appendable.append(": -");
            } else if (this.element.getIdentifier() != null) {
                this.element.dump(appendable.append(": "));
            } else {
                appendable.append(": void");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return appendable;
    }
}

