/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

import java.io.IOException;
import java.util.Vector;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenComplexType;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenContext;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenDeclaration;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenJavaFile;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenOptions;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenSHA;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenUnionArm;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenXdrDefinition;

public class JrpcgenUnion
extends JrpcgenComplexType {
    private final JrpcgenContext context;
    private final JrpcgenDeclaration discriminant;
    private final Vector<JrpcgenUnionArm> elements;

    public String toString() {
        return "union " + this.getIdentifier() + "(" + this.discriminant + "){" + this.elements + "}";
    }

    public JrpcgenUnion(JrpcgenContext context, String identifier, JrpcgenDeclaration discriminant, Vector<JrpcgenUnionArm> elements) {
        super(identifier, JrpcgenXdrDefinition.Type.UNION);
        this.context = context;
        this.discriminant = discriminant;
        this.elements = elements;
    }

    public final JrpcgenDeclaration getDiscriminant() {
        return this.discriminant;
    }

    public final Vector<JrpcgenUnionArm> getElements() {
        return this.elements;
    }

    @Override
    public void generateJavaFile() {
        JrpcgenOptions options = this.context.options();
        try (JrpcgenJavaFile javaFile = JrpcgenJavaFile.open(this.getIdentifier(), this.context);){
            javaFile.writeHeader(true);
            this.writeDocumentation(javaFile);
            javaFile.newLine().beginTypedefinition("public class ").append(this.getIdentifier()).append(" implements XdrAble");
            if (options.makeSerializable) {
                javaFile.append(", java.io.Serializable");
            }
            javaFile.append(" {");
            this.discriminant.writeMemberDeclaration(javaFile.newLine(), "public", this.context.options().initStrings);
            JrpcgenSHA hash = this.context.createSHA(this.getIdentifier());
            for (JrpcgenUnionArm arm : this.elements) {
                arm.updateHash(hash);
                arm.writeMemberDeclaration(javaFile, "public", this.context.options().initStrings);
            }
            if (options.makeSerializable) {
                javaFile.newLine().beginLine().append("private static final long serialVersionUID = ").append(hash.toString()).println("L;");
            }
            javaFile.newLine().beginPublicConstructor(this.getIdentifier()).endSignature().endMethod();
            javaFile.newLine().beginPublicConstructor(this.getIdentifier()).parameter("XdrDecodingStream", "xdr").exceptions("OncRpcException, IOException").endSignature().beginLine().println("xdrDecode(xdr);");
            javaFile.endMethod();
            if (options.generateValueConstructor()) {
                final String valueName = "value".equals(this.discriminant.getIdentifier()) ? "value_" : "value";
                javaFile.newLine().beginPublicConstructor(this.getIdentifier()).parameter(this.discriminant.getTypeMapping().getJavaName(), this.discriminant.getIdentifier()).parameter("Object", valueName).endSignature();
                javaFile.beginLine().append("this.").append(this.discriminant.getIdentifier()).append(" = ").append(this.discriminant.getIdentifier()).println(';');
                this.writeElements(javaFile, new ElementWriter(){

                    @Override
                    public void write(JrpcgenUnionArm arm, JrpcgenJavaFile javaFile) {
                        arm.writeConstructorArm(javaFile, valueName, JrpcgenUnion.this.context);
                    }
                });
                javaFile.endMethod();
            }
            javaFile.newLine().beginLine().println("@Override");
            javaFile.beginPublicMethod().resultType("void").name("xdrEncode").parameter("XdrEncodingStream", "xdr").exceptions("OncRpcException", "IOException").endSignature();
            this.discriminant.writeEncodingPart(javaFile, this.getIdentifier(), this.context);
            this.writeElements(javaFile, new ElementWriter(){

                @Override
                public void write(JrpcgenUnionArm arm, JrpcgenJavaFile javaFile) {
                    arm.writeEncodingPart(javaFile, JrpcgenUnion.this.getIdentifier(), JrpcgenUnion.this.context);
                }
            });
            javaFile.endMethod();
            javaFile.newLine().beginLine().println("@Override");
            javaFile.beginPublicMethod().resultType("void").name("xdrDecode").parameter("XdrDecodingStream", "xdr").exceptions("OncRpcException", "IOException").endSignature();
            this.discriminant.writeDecodingPart(javaFile, this.getIdentifier(), this.context);
            this.writeElements(javaFile, new ElementWriter(){

                @Override
                public void write(JrpcgenUnionArm arm, JrpcgenJavaFile javaFile) {
                    arm.writeDecodingPart(javaFile, JrpcgenUnion.this.getIdentifier(), JrpcgenUnion.this.context);
                }
            });
            javaFile.endMethod();
            if (options.generateToStringMethod()) {
                javaFile.newLine().beginLine().println("@Override");
                javaFile.beginPublicMethod().resultType("String").name("toString").endSignature();
                javaFile.beginLine().append("String ret = \"").append(this.getIdentifier()).println("=\";");
                this.writeElements(javaFile, new ElementWriter(){

                    @Override
                    public void write(JrpcgenUnionArm arm, JrpcgenJavaFile javaFile) {
                        arm.writeToStringPart(javaFile, JrpcgenUnion.this.context);
                    }
                });
                javaFile.beginLine().println("return ret;");
                javaFile.endMethod();
            }
            if (options.generateEqualsMethod()) {
                javaFile.newLine().beginLine().println("@Override");
                javaFile.beginPublicMethod().resultType("boolean").name("equals").parameter("Object", "obj").endSignature();
                javaFile.beginLine().println("if (this == obj) return true;");
                javaFile.beginLine().println("if (obj == null) return false;");
                javaFile.beginLine().println("if (getClass() != obj.getClass()) return false;");
                javaFile.beginLine().append(this.getIdentifier()).append(" other = (").append(this.getIdentifier()).println(")obj;");
                this.discriminant.writeEqualsPart(javaFile, this.context);
                javaFile.beginLine().println("boolean ret = true;");
                this.writeElements(javaFile, new ElementWriter(){

                    @Override
                    public void write(JrpcgenUnionArm arm, JrpcgenJavaFile javaFile) {
                        arm.writeEqualsPart(javaFile, JrpcgenUnion.this.context);
                    }
                });
                javaFile.beginLine().println("return ret;");
                javaFile.endMethod();
                javaFile.newLine().beginLine().println("@Override");
                javaFile.beginPublicMethod().resultType("int").name("hashCode").endSignature().beginLine().println("return XdrHashCode.hashCode(this);");
                javaFile.endMethod();
            }
            this.writeXdrVectorCodingMethods(javaFile, this.context);
            javaFile.newLine().endTypedefinition();
        }
        catch (IOException ioException) {
            System.err.println("Cannot close source code file: " + ioException.getLocalizedMessage());
        }
    }

    public void dump() {
        this.dump(System.out).println();
    }

    public <T extends Appendable> T dump(T appendable) {
        try {
            appendable.append(JrpcgenXdrDefinition.Type.UNION.name()).append(' ').append(this.getIdentifier()).append(':').append(JrpcgenContext.newline()).append("  switch (").append(this.discriminant.getType()).append(' ').append(this.discriminant.getIdentifier()).append(')').append(JrpcgenContext.newline());
            for (JrpcgenUnionArm element : this.elements) {
                element.dump(appendable.append("    ")).append(JrpcgenContext.newline());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return appendable;
    }

    private void writeElements(JrpcgenJavaFile javaFile, ElementWriter elementWriter) {
        if (this.discriminant.getTypeMapping().isBooleanType()) {
            javaFile.beginBlock().append("if ( ").append(this.discriminant.getIdentifier()).println(" == true ) {");
            elementWriter.write(this.elements.get(0), javaFile);
            if (this.elements.get(1).hasPayload()) {
                javaFile.elseBlock().println("} else {");
                elementWriter.write(this.elements.get(1), javaFile);
            }
            javaFile.endBlock().println("}");
        } else {
            javaFile.beginBlock().append("switch ( ").append(this.discriminant.getIdentifier()).println(" ) {");
            for (JrpcgenUnionArm arm : this.elements) {
                arm.startCase(javaFile, this.getIdentifier(), this.context);
                elementWriter.write(arm, javaFile);
                arm.endCase(javaFile);
            }
            javaFile.endBlock().println("}");
        }
    }

    private static interface ElementWriter {
        public void write(JrpcgenUnionArm var1, JrpcgenJavaFile var2);
    }
}

