/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

import java.io.IOException;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenComplexType;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenContext;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenDeclaration;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenOptions;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenSHA;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenStruct;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenTypeMapping;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenXdrDefinition;

public class JrpcgenTypedefinition
extends JrpcgenComplexType {
    private final JrpcgenContext context;
    private final JrpcgenDeclaration declaration;

    public JrpcgenTypedefinition(JrpcgenDeclaration declaration, JrpcgenContext context) {
        super(declaration.getIdentifier(), JrpcgenXdrDefinition.Type.TYPEDEF);
        this.context = context;
        this.declaration = new TypedefDeclaration(declaration.getTypeMapping(), declaration.getKind(), declaration.getSize());
    }

    public final JrpcgenDeclaration getDeclaration() {
        return this.declaration;
    }

    public final String getTypename() {
        return this.declaration.getType();
    }

    @Override
    public void generateJavaFile() {
        JrpcgenDeclaration.Table declarations = new JrpcgenDeclaration.Table();
        JrpcgenStruct wrapperStruct = new JrpcgenStruct(this.context, this.getIdentifier(), declarations);
        JrpcgenOptions options = this.context.options();
        boolean makeBeanOptionGiven = options.makeBean;
        boolean noValueCtorOptionGiven = options.noValueCtor;
        declarations.putItem(this.declaration);
        options.makeBean = false;
        options.noValueCtor = false;
        wrapperStruct.generateJavaFile();
        options.makeBean = makeBeanOptionGiven;
        options.noValueCtor = noValueCtorOptionGiven;
    }

    public void dump() {
        System.out.append(JrpcgenXdrDefinition.Type.TYPEDEF.name()).append(' ');
        this.dump(System.out).println();
    }

    public <T extends Appendable> T dump(T appendable) {
        try {
            appendable.append(this.declaration.getType()).append(JrpcgenDeclaration.Kind.INDIRECTION.equals((Object)this.declaration.getKind()) ? " *" : " ").append(this.getIdentifier());
            switch (this.declaration.getKind()) {
                case FIXEDVECTOR: {
                    appendable.append('[').append(this.declaration.getSize()).append(']');
                    break;
                }
                case DYNAMICVECTOR: {
                    if (this.declaration.getSize() == null) {
                        appendable.append("<>");
                        break;
                    }
                    appendable.append('<').append(this.declaration.getSize()).append('>');
                    break;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return appendable;
    }

    private class TypedefDeclaration
    extends JrpcgenDeclaration {
        public TypedefDeclaration(JrpcgenTypeMapping typeMapping, JrpcgenDeclaration.Kind kind, String size) {
            super("value", typeMapping, kind, size);
        }

        @Override
        public void updateHash(JrpcgenSHA hash) {
            hash.update(this.getType());
            hash.update(this.getKind().ordinal());
        }
    }
}

