/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

import java.io.IOException;
import java.util.LinkedList;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenBaseType;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenComplexType;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenContext;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenJavaFile;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenTypeMapping;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenXdrDefinition;

public class JrpcgenTypeInfo
implements JrpcgenTypeMapping {
    private final JrpcgenContext context;
    private final String definitionName;
    private JrpcgenTypeMapping mapping;

    public static JrpcgenTypeInfo getTypeInfo(JrpcgenContext context, String type) {
        return new JrpcgenTypeInfo(context, type, JrpcgenBaseType.getBaseType(type));
    }

    public static void generateCodingSupplement(JrpcgenContext context) {
        LinkedList<String> typesInQuestion = new LinkedList<String>();
        for (String typename : context.predefinedTypes()) {
            if (!context.typesInDynamicVectorUse().contains(typename) && !context.typesInFixedVectorUse().contains(typename)) continue;
            typesInQuestion.add(typename);
        }
        if (context.predefinedTypes().size() > 0) {
            String className = context.options().baseClassname.concat("CodingSupplement");
            try (JrpcgenJavaFile javaFile = JrpcgenJavaFile.open(className, context);){
                javaFile.writeHeader(true);
                javaFile.beginTypedefinition("public class ").append(className).println(" {");
                for (String typename : context.predefinedTypes()) {
                    PredefinedType predefinedType = new PredefinedType(typename, className);
                    boolean generateDynamicVectorCodingMethod = context.typesInDynamicVectorUse().contains(typename);
                    javaFile.newLine().beginPublicMethod().staticMethod().resultType(typename).name("xdrDecode_".concat(typename)).parameter("XdrDecodingStream", "xdr").exceptions("OncRpcException", "IOException").endSignature().beginLine().append(typename).space().append("$result = ").keywordNew().space().append(typename).println("();").beginLine().println("$result.xdrDecode(xdr);").beginLine().keywordReturn().space().append("$result").semicolon().newLine().endMethod();
                    if (!generateDynamicVectorCodingMethod && !context.typesInFixedVectorUse().contains(typename)) continue;
                    javaFile.newLine().beginPublicMethod().staticMethod().resultType("void").name("xdrEncodeFixedVector_".concat(typename)).parameter("XdrEncodingStream", "xdr").parameter(typename.concat("[]"), "vector").parameter("int", "size").exceptions("OncRpcException", "IOException").endSignature().beginBlock().println("if (vector.length != size) {").beginLine().println("throw new IllegalArgumentException(\"array size does not match protocol specification\");").endBlock().println('}').newLine().beginBlock().println("for (int index = 0; index < size; index++) {").beginLine();
                    predefinedType.writeXdrEncodingCall(javaFile, "xdr", "vector[index]");
                    javaFile.semicolon().newLine().endBlock().println('}').endMethod();
                    javaFile.newLine().beginPublicMethod().staticMethod().resultType(typename, "[]").name("xdrDecodeFixedVector_".concat(typename)).parameter("XdrDecodingStream", "xdr").parameter("int", "size").exceptions("OncRpcException", "IOException").endSignature().beginLine().append(typename).append("[] vector = new ").append(typename).println("[size];").newLine().beginBlock().println("for (int index = 0; index < size; index++) {").beginLine().append("vector[index] = ");
                    predefinedType.writeXdrDecodingCall(javaFile, "xdr");
                    javaFile.semicolon().newLine().endBlock().println('}').newLine().beginLine().keywordReturn().space().append("vector").semicolon().newLine().endMethod();
                    if (!generateDynamicVectorCodingMethod) continue;
                    javaFile.newLine().beginPublicMethod().staticMethod().resultType("void").name("xdrEncodeDynamicVector_".concat(typename)).parameter("XdrEncodingStream", "xdr").parameter(typename.concat("[]"), "vector").exceptions("OncRpcException", "IOException").endSignature().beginLine();
                    JrpcgenBaseType.INT.writeXdrEncodingCall(javaFile, "xdr", "vector.length");
                    javaFile.semicolon().beginNewLine().append("xdrEncodeFixedVector_").append(typename).println("(xdr, vector, vector.length);").endMethod();
                    javaFile.newLine().beginPublicMethod().staticMethod().resultType(typename, "[]").name("xdrDecodeDynamicVector_".concat(typename)).parameter("XdrDecodingStream", "xdr").exceptions("OncRpcException", "IOException").endSignature().beginLine().keywordReturn().space().append("xdrDecodeFixedVector_").append(typename).append("(xdr, ");
                    JrpcgenBaseType.INT.writeXdrDecodingCall(javaFile, "xdr");
                    javaFile.rightParenthesis().semicolon().newLine().endMethod();
                }
                javaFile.endTypedefinition();
            }
            catch (IOException ioException) {
                System.err.println("Cannot close source code file: " + ioException.getLocalizedMessage());
            }
        }
    }

    @Override
    public final boolean isVoid() {
        return JrpcgenBaseType.VOID.equals(this.mapping);
    }

    @Override
    public final boolean isBaseType() {
        return this.mapping instanceof JrpcgenBaseType;
    }

    @Override
    public final boolean isBooleanType() {
        return JrpcgenBaseType.BOOL.equals(this.mapping);
    }

    @Override
    public final boolean isStringType() {
        return JrpcgenBaseType.STRING.equals(this.mapping);
    }

    @Override
    public final boolean isOpaqueType() {
        return JrpcgenBaseType.OPAQUE.equals(this.mapping);
    }

    @Override
    public final String getDefinitionName() {
        return this.definitionName;
    }

    @Override
    public final String getJavaName() {
        return this.getMapping().getJavaName();
    }

    @Override
    public final String getJavaClass() {
        return this.getMapping().getJavaClass();
    }

    @Override
    public final String getXdrClass() {
        return this.getMapping().getXdrClass();
    }

    @Override
    public final void writeXdrConstructorCall(JrpcgenJavaFile javaFile, String parameter) {
        this.getMapping().writeXdrConstructorCall(javaFile, parameter);
    }

    @Override
    public final void writeXdrConstructorCall(JrpcgenJavaFile javaFile, JrpcgenJavaFile.Expression parameterExpression) {
        this.getMapping().writeXdrConstructorCall(javaFile, parameterExpression);
    }

    @Override
    public final void writeJavaToXdr(JrpcgenJavaFile javaFile, String variable) {
        this.getMapping().writeJavaToXdr(javaFile, variable);
    }

    @Override
    public final void writeJavaToXdr(JrpcgenJavaFile javaFile, JrpcgenJavaFile.Expression expression) {
        this.getMapping().writeJavaToXdr(javaFile, expression);
    }

    @Override
    public final void writeXdrToJava(JrpcgenJavaFile javaFile, String variable) {
        this.getMapping().writeXdrToJava(javaFile, variable);
    }

    @Override
    public final void writeXdrEncodingCall(JrpcgenJavaFile javaFile, String xdrStream, String variable) {
        this.getMapping().writeXdrEncodingCall(javaFile, xdrStream, variable);
    }

    @Override
    public final void writeXdrEncodingCall(JrpcgenJavaFile javaFile, String xdrStream, JrpcgenJavaFile.Expression expression) {
        this.getMapping().writeXdrEncodingCall(javaFile, xdrStream, expression);
    }

    @Override
    public final void writeXdrFixedVectorEncodingCall(JrpcgenJavaFile javaFile, String xdrStream, String variable, String size) {
        this.getMapping().writeXdrFixedVectorEncodingCall(javaFile, xdrStream, variable, size);
    }

    @Override
    public final void writeXdrDynamicVectorEncodingCall(JrpcgenJavaFile javaFile, String xdrStream, String variable) {
        this.getMapping().writeXdrDynamicVectorEncodingCall(javaFile, xdrStream, variable);
    }

    @Override
    public final void writeXdrDecodingCall(JrpcgenJavaFile javaFile, String xdrStream) {
        this.getMapping().writeXdrDecodingCall(javaFile, xdrStream);
    }

    @Override
    public final void writeXdrFixedVectorDecodingCall(JrpcgenJavaFile javaFile, String xdrStream, String size) {
        this.getMapping().writeXdrFixedVectorDecodingCall(javaFile, xdrStream, size);
    }

    @Override
    public final void writeXdrDynamicVectorDecodingCall(JrpcgenJavaFile javaFile, String xdrStream) {
        this.getMapping().writeXdrDynamicVectorDecodingCall(javaFile, xdrStream);
    }

    @Override
    public final void writeEqualsExpression(JrpcgenJavaFile javaFile, String variableLeft, String variableRight, boolean negate) {
        this.getMapping().writeEqualsExpression(javaFile, variableLeft, variableRight, negate);
    }

    private JrpcgenTypeInfo(JrpcgenContext context, String definitionName, JrpcgenTypeMapping mapping) {
        this.context = context;
        this.definitionName = definitionName;
        this.mapping = mapping;
    }

    private JrpcgenTypeMapping getMapping() {
        if (this.mapping == null) {
            this.mapping = this.context.globalDefinitions().getItem(JrpcgenComplexType.class, this.definitionName);
            if (this.mapping == null) {
                this.context.predefinedTypes().add(this.definitionName);
                this.mapping = new PredefinedType(this.definitionName, this.context.options().baseClassname.concat("CodingSupplement"));
            }
        }
        return this.mapping;
    }

    private static class PredefinedType
    extends JrpcgenComplexType {
        private final String codingSupplementIdentifier;

        public PredefinedType(String identifier, String codingSupplementIdentifier) {
            super(identifier, JrpcgenXdrDefinition.Type.STRUCT);
            this.codingSupplementIdentifier = codingSupplementIdentifier;
        }

        @Override
        public void generateJavaFile() {
        }

        @Override
        public void writeXdrDecodingCall(JrpcgenJavaFile javaFile, String xdrStream) {
            javaFile.append(this.codingSupplementIdentifier).dot().append("xdrDecode_").append(this.getIdentifier()).leftParenthesis().append(xdrStream).rightParenthesis();
        }

        @Override
        public void writeXdrFixedVectorEncodingCall(JrpcgenJavaFile javaFile, String xdrStream, String variable, String size) {
            javaFile.append(this.codingSupplementIdentifier).dot().append("xdrEncodeFixedVector_").append(this.getIdentifier()).leftParenthesis().append(xdrStream).append(", ").append(variable).append(", ").append(size).rightParenthesis();
        }

        @Override
        public void writeXdrDynamicVectorEncodingCall(JrpcgenJavaFile javaFile, String xdrStream, String variable) {
            javaFile.append(this.codingSupplementIdentifier).dot().append("xdrEncodeDynamicVector_").append(this.getIdentifier()).leftParenthesis().append(xdrStream).append(", ").append(variable).rightParenthesis();
        }

        @Override
        public void writeXdrFixedVectorDecodingCall(JrpcgenJavaFile javaFile, String xdrStream, String size) {
            javaFile.append(this.codingSupplementIdentifier).dot().append("xdrDecodeFixedVector_").append(this.getIdentifier()).leftParenthesis().append(xdrStream).append(", ").append(size).rightParenthesis();
        }

        @Override
        public void writeXdrDynamicVectorDecodingCall(JrpcgenJavaFile javaFile, String xdrStream) {
            javaFile.append(this.codingSupplementIdentifier).dot().append("xdrDecodeDynamicVector_").append(this.getIdentifier()).leftParenthesis().append(xdrStream).rightParenthesis();
        }
    }
}

