/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

import java.io.IOException;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenBaseType;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenComplexType;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenContext;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenDeclaration;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenJavaFile;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenOptions;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenSHA;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenXdrDefinition;

public class JrpcgenStruct
extends JrpcgenComplexType {
    private static long NEXT_UNNAMED_STRUCT_ID = 1L;
    private final JrpcgenContext context;
    private final JrpcgenDeclaration.Table elements;

    public JrpcgenStruct(JrpcgenContext context, String identifier, JrpcgenDeclaration.Table elements) {
        super(JrpcgenStruct.getIdentifier(identifier), JrpcgenXdrDefinition.Type.STRUCT);
        this.context = context;
        this.elements = elements;
    }

    private static String getIdentifier(String identifier) {
        return identifier != null ? identifier : "unnamed_struct_" + NEXT_UNNAMED_STRUCT_ID++;
    }

    public final JrpcgenDeclaration.Table getElements() {
        return this.elements;
    }

    @Override
    public void generateJavaFile() {
        JrpcgenOptions options = this.context.options();
        String access = options.makeBean ? "protected" : "public";
        try (JrpcgenJavaFile javaFile = JrpcgenJavaFile.open(this.getIdentifier(), this.context);){
            javaFile.writeHeader(true);
            this.writeDocumentation(javaFile);
            javaFile.newLine().beginTypedefinition("public class ").append(this.getIdentifier()).append(" implements XdrAble");
            if (options.makeSerializable) {
                javaFile.append(", java.io.Serializable");
            }
            javaFile.append(" {").newLine();
            boolean useIteration = false;
            JrpcgenSHA hash = this.context.createSHA(this.getIdentifier());
            for (final JrpcgenDeclaration declaration : this.elements.getItemList()) {
                declaration.updateHash(hash);
                declaration.writeMemberDeclaration(javaFile, access, options.initStrings);
                if (declaration != this.elements.getLastItem() || !JrpcgenDeclaration.Kind.INDIRECTION.equals((Object)declaration.getKind()) || !declaration.getType().equals(this.getIdentifier())) continue;
                useIteration = true;
            }
            if (options.makeSerializable) {
                javaFile.newLine().beginLine().append("private static final long serialVersionUID = ").append(hash.toString()).println("L;");
                if (options.makeBean) {
                    for (final JrpcgenDeclaration declaration : this.elements.getItemList()) {
                        declaration.writeGettersAndSetters(javaFile.newLine());
                    }
                }
            }
            javaFile.newLine().beginPublicConstructor(this.getIdentifier()).endSignature().endMethod();
            javaFile.newLine().beginPublicConstructor(this.getIdentifier()).parameter("XdrDecodingStream", "xdr").exceptions("OncRpcException", "IOException").endSignature();
            javaFile.beginLine().println("xdrDecode(xdr);");
            javaFile.endMethod();
            if (options.generateValueConstructor()) {
                this.writeValueConstructor(javaFile);
            }
            javaFile.newLine().beginLine().println("@Override");
            javaFile.beginPublicMethod().resultType("void").name("xdrEncode").parameter("XdrEncodingStream", "xdr").exceptions("OncRpcException", "IOException").endSignature();
            if (useIteration) {
                javaFile.beginBlock().append("for (").append(this.getIdentifier()).space().append("$current = this; $current != null; $current = $current.").append(((JrpcgenDeclaration)this.elements.getLastItem()).getIdentifier()).println(") {");
                for (final JrpcgenDeclaration declaration : this.elements.getItemList()) {
                    if (declaration != this.elements.getLastItem()) {
                        declaration.writeEncodingPart(javaFile, this.getIdentifier(), "$current", this.context);
                        continue;
                    }
                    JrpcgenBaseType.BOOL.writeXdrEncodingCall(javaFile.beginLine(), "xdr", new JrpcgenJavaFile.Expression(){

                        @Override
                        public void writeTo(JrpcgenJavaFile javaFile) {
                            javaFile.append("$current.").append(declaration.getIdentifier()).append(" != null");
                        }
                    });
                    javaFile.semicolon().newLine();
                }
                javaFile.endBlock().println('}');
            } else {
                for (final JrpcgenDeclaration declaration : this.elements.getItemList()) {
                    declaration.writeEncodingPart(javaFile, this.getIdentifier(), this.context);
                }
            }
            javaFile.endMethod();
            javaFile.newLine().beginLine().println("@Override");
            javaFile.beginPublicMethod().resultType("void").name("xdrDecode").parameter("XdrDecodingStream", "xdr").exceptions("OncRpcException", "IOException").endSignature();
            if (useIteration) {
                javaFile.beginBlock().append("for (").append(this.getIdentifier()).space().append("$current = this; $current != null; $current = $current.").append(((JrpcgenDeclaration)this.elements.getLastItem()).getIdentifier()).println(") {");
                for (final JrpcgenDeclaration declaration : this.elements) {
                    if (declaration != this.elements.getLastItem()) {
                        declaration.writeDecodingPart(javaFile, this.getIdentifier(), "$current", this.context);
                        continue;
                    }
                    javaFile.beginLine().append("$current.").append(declaration.getIdentifier()).append(" = ");
                    JrpcgenBaseType.BOOL.writeXdrDecodingCall(javaFile, "xdr");
                    javaFile.append(" ? ");
                    this.writeXdrConstructorCall(javaFile, (String)null);
                    javaFile.println(" : null;");
                }
                javaFile.endBlock().println('}');
            } else {
                for (final JrpcgenDeclaration declaration : this.elements.getItemList()) {
                    declaration.writeDecodingPart(javaFile, this.getIdentifier(), this.context);
                }
            }
            javaFile.endMethod();
            if (options.generateToStringMethod()) {
                this.writeToStringMethod(javaFile);
            }
            if (options.generateEqualsMethod()) {
                this.writeEqualsMethod(javaFile);
            }
            this.writeXdrVectorCodingMethods(javaFile, this.context);
            javaFile.newLine().endTypedefinition();
        }
        catch (IOException ioException) {
            System.err.println("Cannot close source code file: " + ioException.getLocalizedMessage());
        }
    }

    public String toString() {
        return this.dump(new StringBuilder()).toString();
    }

    public void dump() {
        this.dump(System.out).println();
    }

    public <T extends Appendable> T dump(T appendable) {
        try {
            appendable.append(JrpcgenXdrDefinition.Type.STRUCT.name()).append(' ').append(this.getIdentifier()).append(':').append(JrpcgenContext.newline());
            for (JrpcgenDeclaration element : this.elements.getItemList()) {
                element.dump(appendable.append("  ")).append(JrpcgenContext.newline());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return appendable;
    }

    private void writeValueConstructor(JrpcgenJavaFile javaFile) {
        JrpcgenJavaFile.MethodSignature signature = javaFile.newLine().beginPublicConstructor(this.getIdentifier());
        for (JrpcgenDeclaration declaration : this.elements) {
            signature.parameterLineBreak(declaration.getJavaType(), declaration.getIdentifier(), 80);
        }
        signature.endSignature();
        for (JrpcgenDeclaration declaration : this.elements.getItemList()) {
            javaFile.beginLine().append("this.").append(declaration.getIdentifier()).append(" = ").append(declaration.getIdentifier()).println(";");
        }
        javaFile.endMethod();
    }

    private void writeToStringMethod(JrpcgenJavaFile javaFile) {
        javaFile.newLine().beginLine().println("@Override");
        javaFile.beginPublicMethod().resultType("String").name("toString").endSignature();
        javaFile.beginLine().append("return \"").append(this.getIdentifier()).println(" [\"");
        for (JrpcgenDeclaration declaration : this.elements.getItemList()) {
            declaration.writeToStringPart(javaFile);
            if (declaration != this.elements.getLastItem()) {
                javaFile.append(" + \", \"").newLine();
                continue;
            }
            javaFile.newLine();
        }
        javaFile.beginLine().println("+ \"]\";");
        javaFile.endMethod();
    }

    private void writeEqualsMethod(JrpcgenJavaFile javaFile) {
        javaFile.newLine().beginLine().println("@Override");
        javaFile.beginPublicMethod().resultType("boolean").name("equals").parameter("Object", "obj").endSignature();
        javaFile.beginLine().println("if (this == obj) return true;");
        javaFile.beginLine().println("if (obj == null) return false;");
        javaFile.beginLine().println("if (getClass() != obj.getClass()) return false;");
        javaFile.beginLine().append(this.getIdentifier()).append(" other = (").append(this.getIdentifier()).println(")obj;");
        for (JrpcgenDeclaration declaration : this.elements.getItemList()) {
            declaration.writeEqualsPart(javaFile, this.context);
        }
        javaFile.beginLine().println("return true;");
        javaFile.endMethod();
        javaFile.newLine().beginLine().println("@Override");
        javaFile.beginPublicMethod().resultType("int").name("hashCode").endSignature().beginLine().println("return XdrHashCode.hashCode(this);");
        javaFile.endMethod();
    }
}

