/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class JrpcgenSHA {
    private MessageDigest digest;

    public JrpcgenSHA() {
        this.reset();
    }

    public void update(byte b) {
        this.digest.update(b);
    }

    public void update(short s) {
        for (int pos = 0; pos < 2; ++pos) {
            this.update((byte)(s >> pos * 8 & 0xFF));
        }
    }

    public void update(int i) {
        for (int pos = 0; pos < 4; ++pos) {
            this.update((byte)(i >> pos * 8 & 0xFF));
        }
    }

    public void update(String s) {
        for (char ch : s.toCharArray()) {
            this.update((short)ch);
        }
    }

    public long getHash() {
        byte[] h = this.digest.digest();
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result += ((long)h[i] & 0xFFL) << i * 8;
        }
        return result;
    }

    public String toString() {
        return String.valueOf(this.getHash());
    }

    private void reset() {
        try {
            this.digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("This JVM doesn't supply SHA-1; something is seriously wrong");
        }
    }
}

