/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

import java.io.IOException;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenConst;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenContext;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenDocumentable;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenItem;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenItemTable;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenJavaFile;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenOptions;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenProcedureInfo;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenVersionInfo;

class JrpcgenProgramInfo
extends JrpcgenDocumentable
implements JrpcgenItem {
    public String programNumber;
    public String programId;
    public JrpcgenVersionInfo.Table versions;
    private final JrpcgenContext context;

    public JrpcgenProgramInfo(JrpcgenContext context, String programId, String programNumber, JrpcgenVersionInfo.Table versions) {
        this.context = context;
        this.programId = programId;
        this.programNumber = programNumber;
        this.versions = versions;
        this.completeProcedureConstants();
    }

    @Override
    public String getIdentifier() {
        return this.programId;
    }

    public void writeProgramInterface() {
        String serviceClass = this.context.getInterfaceName(this.programId);
        try (JrpcgenJavaFile javaFile = JrpcgenJavaFile.open(serviceClass, this.context);){
            javaFile.writeHeader(true);
            this.writeDocumentation(javaFile);
            javaFile.newLine().beginTypedefinition("public interface ").append(serviceClass).println(" {");
            javaFile.newLine();
            for (JrpcgenVersionInfo version : this.versions) {
                for (JrpcgenProcedureInfo procedure : version.procedures) {
                    procedure.writeInterfaceDeclaration(javaFile, this.context);
                }
            }
            javaFile.newLine().endTypedefinition();
        }
        catch (IOException ioException) {
            System.err.println("Cannot close source code file: " + ioException.getLocalizedMessage());
        }
    }

    public void writeClientStub() {
        String clientClass = this.context.options().clientClass;
        String baseClassname = this.context.options().baseClassname;
        int versionMax = Integer.MIN_VALUE;
        if (clientClass == null) {
            clientClass = "" + baseClassname + "_" + this.programId + "_Client";
            System.out.println("CLIENT: " + clientClass);
        }
        for (JrpcgenVersionInfo version : this.versions) {
            int versionCurrent = Integer.parseInt(version.versionNumber);
            if (versionCurrent <= versionMax) continue;
            versionMax = versionCurrent;
        }
        try (JrpcgenJavaFile javaFile = JrpcgenJavaFile.open(clientClass, this.context);){
            javaFile.writeHeader(true);
            javaFile.beginLine().println("import java.net.InetAddress;");
            javaFile.beginNewLine().println("/**");
            javaFile.beginLine().println(" * The class <code>" + clientClass + "</code> implements the client stub proxy");
            javaFile.beginLine().println(" * for the " + this.programId + " remote program. It provides method stubs");
            javaFile.beginLine().println(" * which, when called, in turn call the appropriate remote method (procedure).");
            javaFile.beginLine().println(" */");
            javaFile.beginTypedefinition("public class ").append(clientClass).append(" extends OncRpcClientStub implements ").append(this.context.getInterfaceName(this.programId)).println(" {");
            javaFile.beginNewLine().println("/**");
            javaFile.beginLine().append(" * Constructs a <code>").append(clientClass).println("</code> client stub proxy dummy.");
            javaFile.beginLine().println(" * @throws OncRpcException if an ONC/RPC error occurs.");
            javaFile.beginLine().println(" * @throws IOException if an I/O error occurs.");
            javaFile.beginLine().println(" */");
            javaFile.beginPublicConstructor(clientClass).exceptions("OncRpcException", "IOException").endSignature().beginLine().println("super(null);");
            javaFile.endMethod();
            javaFile.beginNewLine().println("/**");
            javaFile.beginLine().append(" * Constructs a <code>").append(clientClass).println("</code> client stub proxy object");
            javaFile.beginLine().append(" * from which the ").append(this.programId).println(" remote program can be accessed.");
            javaFile.beginLine().println(" * @param host Internet address of host where to contact the remote program.");
            javaFile.beginLine().println(" * @param protocol {@link org.acplt.oncrpc.OncRpcProtocols Protocol} to be");
            javaFile.beginLine().println(" *   used for ONC/RPC calls.");
            javaFile.beginLine().println(" * @throws OncRpcException if an ONC/RPC error occurs.");
            javaFile.beginLine().println(" * @throws IOException if an I/O error occurs.");
            javaFile.beginLine().println(" */");
            javaFile.beginPublicConstructor(clientClass).parameter("InetAddress", "host").parameter("int", "protocol").exceptions("OncRpcException", "IOException").endSignature().beginLine().append("super(host, ").append(baseClassname).append('.').append(this.programId).append(", ").append(String.valueOf(versionMax)).println(", 0, protocol);");
            javaFile.endMethod();
            javaFile.beginNewLine().println("/**");
            javaFile.beginLine().append(" * Constructs a <code>").append(clientClass).println("</code> client stub proxy object");
            javaFile.beginLine().append(" * from which the ").append(this.programId).println(" remote program can be accessed.");
            javaFile.beginLine().println(" * @param host Internet address of host where to contact the remote program.");
            javaFile.beginLine().println(" * @param port Port number at host where the remote program can be reached.");
            javaFile.beginLine().println(" * @param protocol {@link org.acplt.oncrpc.OncRpcProtocols Protocol} to be");
            javaFile.beginLine().println(" *   used for ONC/RPC calls.");
            javaFile.beginLine().println(" * @throws OncRpcException if an ONC/RPC error occurs.");
            javaFile.beginLine().println(" * @throws IOException if an I/O error occurs.");
            javaFile.beginLine().println(" */");
            javaFile.beginPublicConstructor(clientClass).parameter("InetAddress", "host").parameter("int", "port").parameter("int", "protocol").exceptions("OncRpcException", "IOException").endSignature().beginLine().append("super(host, ").append(baseClassname).append('.').append(this.programId).append(", ").append(String.valueOf(versionMax)).println(", port, protocol);");
            javaFile.endMethod();
            javaFile.beginNewLine().println("/**");
            javaFile.beginLine().append(" * Constructs a <code>").append(clientClass).println("</code> client stub proxy object");
            javaFile.beginLine().append(" * from which the ").append(this.programId).println(" remote program can be accessed.");
            javaFile.beginLine().println(" * @param client ONC/RPC client connection object implementing a particular");
            javaFile.beginLine().println(" *   protocol.");
            javaFile.beginLine().println(" * @throws OncRpcException if an ONC/RPC error occurs.");
            javaFile.beginLine().println(" * @throws IOException if an I/O error occurs.");
            javaFile.beginLine().println(" */");
            javaFile.beginPublicConstructor(clientClass).parameter("OncRpcClient", "client").exceptions("OncRpcException", "IOException").endSignature().beginLine().println("super(client);");
            javaFile.endMethod();
            javaFile.beginNewLine().println("/**");
            javaFile.beginLine().append(" * Constructs a <code>").append(clientClass).println("</code> client stub proxy object");
            javaFile.beginLine().append(" * from which the ").append(this.programId).println(" remote program can be accessed.");
            javaFile.beginLine().println(" * @param host Internet address of host where to contact the remote program.");
            javaFile.beginLine().println(" * @param program Remote program number.");
            javaFile.beginLine().println(" * @param version Remote program version number.");
            javaFile.beginLine().println(" * @param protocol {@link org.acplt.oncrpc.OncRpcProtocols Protocol} to be");
            javaFile.beginLine().println(" *   used for ONC/RPC calls.");
            javaFile.beginLine().println(" * @throws OncRpcException if an ONC/RPC error occurs.");
            javaFile.beginLine().println(" * @throws IOException if an I/O error occurs.");
            javaFile.beginLine().println(" */");
            javaFile.beginPublicConstructor(clientClass).parameter("InetAddress", "host").parameter("int", "program").parameter("int", "version").parameter("int", "protocol").exceptions("OncRpcException", "IOException").endSignature().beginLine().println("super(host, program, version, 0, protocol);");
            javaFile.endMethod();
            javaFile.beginNewLine().println("/**");
            javaFile.beginLine().append(" * Constructs a <code>").append(clientClass).println("</code> client stub proxy object");
            javaFile.beginLine().append(" * from which the ").append(this.programId).println(" remote program can be accessed.");
            javaFile.beginLine().println(" * @param host Internet address of host where to contact the remote program.");
            javaFile.beginLine().println(" * @param program Remote program number.");
            javaFile.beginLine().println(" * @param version Remote program version number.");
            javaFile.beginLine().println(" * @param port Port number at host where the remote program can be reached.");
            javaFile.beginLine().println(" * @param protocol {@link org.acplt.oncrpc.OncRpcProtocols Protocol} to be");
            javaFile.beginLine().println(" *   used for ONC/RPC calls.");
            javaFile.beginLine().println(" * @throws OncRpcException if an ONC/RPC error occurs.");
            javaFile.beginLine().println(" * @throws IOException if an I/O error occurs.");
            javaFile.beginLine().println(" */");
            javaFile.beginPublicConstructor(clientClass).parameter("InetAddress", "host").parameter("int", "program").parameter("int", "version").parameter("int", "port").parameter("int", "protocol").exceptions("OncRpcException", "IOException").endSignature().beginLine().println("super(host, program, version, port, protocol);");
            javaFile.endMethod();
            for (JrpcgenVersionInfo version : this.versions) {
                version.writeClientStubMethods(javaFile);
            }
            javaFile.newLine().endTypedefinition();
        }
        catch (IOException ioException) {
            System.err.println("Cannot close source code file: " + ioException.getLocalizedMessage());
        }
    }

    public void writeServerStub() {
        JrpcgenOptions options = this.context.options();
        String serverClass = options.serverClass;
        String baseClassname = options.baseClassname;
        if (serverClass == null) {
            serverClass = "" + baseClassname + "_" + this.programId + "_ServerStub";
            System.out.println("SERVER: " + serverClass);
        }
        try (JrpcgenJavaFile javaFile = JrpcgenJavaFile.open(serverClass, this.context);){
            javaFile.writeHeader(true);
            javaFile.beginLine().println("import java.net.InetAddress;");
            javaFile.beginNewLine().println("import org.acplt.oncrpc.server.*;");
            javaFile.beginNewLine().println("/**");
            javaFile.beginLine().println(" */");
            javaFile.beginTypedefinition("public abstract class ").append(serverClass).println(" extends OncRpcServerStub implements OncRpcDispatchable {");
            javaFile.newLine().beginPublicConstructor(serverClass).exceptions("OncRpcException", "IOException").endSignature().beginLine().println("this(0);").endMethod();
            javaFile.newLine().beginPublicConstructor(serverClass).parameter("int", "port").exceptions("OncRpcException", "IOException").endSignature().beginLine().println("this(null, port);").endMethod();
            javaFile.newLine().beginPublicConstructor(serverClass).parameter("InetAddress", "bindAddr").parameter("int", "port").exceptions("OncRpcException", "IOException").endSignature();
            javaFile.beginBlock().println("info = new OncRpcServerTransportRegistrationInfo [] {");
            for (JrpcgenVersionInfo version : this.versions) {
                if (version != this.versions.getLastItem()) {
                    javaFile.beginLine().append("new OncRpcServerTransportRegistrationInfo(").append(baseClassname).dot().append(this.programId).append(", ").append(version.versionNumber).println("),");
                    continue;
                }
                javaFile.beginLine().append("new OncRpcServerTransportRegistrationInfo(").append(baseClassname).dot().append(this.programId).append(", ").append(version.versionNumber).println(')');
            }
            javaFile.endBlock().println("};");
            javaFile.beginBlock().println("transports = new OncRpcServerTransport [] {");
            if (options.generateUdpTransport()) {
                javaFile.beginLine().append("new OncRpcUdpServerTransport(this, bindAddr, port, info, 32768)");
                if (options.generateTcpTransport()) {
                    javaFile.println(',').beginLine().println("new OncRpcTcpServerTransport(this, bindAddr, port, info, 32768)");
                } else {
                    javaFile.newLine();
                }
            } else if (options.generateTcpTransport()) {
                javaFile.beginLine().println("new OncRpcTcpServerTransport(this, bindAddr, port, info, 32768)");
            }
            javaFile.endBlock().println("};");
            javaFile.endMethod();
            javaFile.newLine();
            javaFile.beginPublicMethod().resultType("void").name("dispatchOncRpcCall").parameter("OncRpcCallInformation", "call").parameter("int", "program").parameter("int", "version").parameter("int", "procedure").exceptions("OncRpcException", "IOException").endSignature();
            for (JrpcgenVersionInfo version : this.versions) {
                if (version == this.versions.getFirstItem()) {
                    javaFile.beginBlock().append("if ( version == ").append(version.versionNumber).println(" ) {");
                } else {
                    javaFile.elseBlock().append("} else if ( version == ").append(version.versionNumber).println(" ) {");
                }
                version.writeServerStubMethodCalls(javaFile);
            }
            javaFile.elseBlock().println("} else {").beginLine().println("call.failProgramUnavailable();").endBlock().println('}').endMethod();
            javaFile.newLine();
            for (JrpcgenVersionInfo version : this.versions) {
                version.writeServerStubMethods(javaFile);
            }
            javaFile.endTypedefinition();
        }
        catch (IOException ioException) {
            System.err.println("Cannot close source code file: " + ioException.getLocalizedMessage());
        }
    }

    public String toString() {
        return this.dump(new StringBuilder()).toString();
    }

    public void dump() {
        this.dump(System.out).println();
    }

    public <T extends Appendable> T dump(T appendable) {
        try {
            appendable.append("PROGRAM ").append(this.programId).append(" = ").append(this.programNumber);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return appendable;
    }

    private void completeProcedureConstants() {
        for (JrpcgenVersionInfo version : this.versions) {
            for (JrpcgenConst procedureConstant : version.getProcedureConstants()) {
                procedureConstant.setDocumentation("/** RPC procedure number of {@linkplain " + this.context.getInterfaceName(this.programId) + "#" + procedureConstant.getIdentifier() + "}" + JrpcgenContext.newline() + " * value = " + procedureConstant.getValue() + " */");
            }
        }
    }

    public static class Table
    extends JrpcgenItemTable<JrpcgenProgramInfo> {
    }
}

