/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

import java.io.IOException;
import java.util.Iterator;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenBaseType;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenConst;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenContext;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenDocumentable;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenItem;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenItemTable;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenJavaFile;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenParamInfo;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenTypeInfo;

class JrpcgenProcedureInfo
extends JrpcgenDocumentable
implements JrpcgenItem {
    public String procedureNumber;
    public String procedureId;
    public JrpcgenParamInfo.Table parameters;
    private JrpcgenConst constant;
    private JrpcgenTypeInfo resultTypeInfo;

    public JrpcgenProcedureInfo(String jdoc, String procedureId, String procedureNumber, JrpcgenTypeInfo resultTypeInfo, JrpcgenParamInfo.Table parameters) {
        super(jdoc);
        this.procedureId = procedureId;
        this.procedureNumber = procedureNumber;
        this.parameters = parameters;
        this.resultTypeInfo = resultTypeInfo;
    }

    public JrpcgenProcedureInfo(String procedureId, String procedureNumber, JrpcgenTypeInfo resultTypeInfo, JrpcgenParamInfo.Table parameters) {
        this(null, procedureId, procedureNumber, resultTypeInfo, parameters);
    }

    public String getResultType() {
        return this.resultTypeInfo.getDefinitionName();
    }

    public void setConstant(JrpcgenConst constant) {
        this.constant = constant;
    }

    public JrpcgenConst getConstant() {
        return this.constant;
    }

    @Override
    public void writeDocumentation(JrpcgenJavaFile javaFile) {
        if (this.documentationIsProvided()) {
            super.writeDocumentation(javaFile);
        } else {
            javaFile.beginLine().println("/**");
            javaFile.beginLine().append(" * Call remote procedure ").append(this.procedureId).println('.');
            if (this.parameters != null) {
                for (JrpcgenParamInfo param : this.parameters) {
                    javaFile.beginLine().append(" * @param ").append(param.getName()).append(" parameter (of type ").append(param.getTypeInfo().getJavaName()).println(") to the remote procedure call.");
                }
            }
            if (JrpcgenBaseType.VOID.getJavaName().compareTo(this.resultTypeInfo.getJavaName()) != 0) {
                javaFile.beginLine().append(" * @return Result from remote procedure call (of type ").append(this.getResultType()).println(").");
            }
            javaFile.beginLine().println(" * @throws OncRpcException if an ONC/RPC error occurs.");
            javaFile.beginLine().println(" * @throws IOException if an I/O error occurs.");
            javaFile.beginLine().append(" */");
            this.appendDeprecatedOrNothing(javaFile);
        }
    }

    public void writeClientStubSignature(JrpcgenJavaFile javaFile) {
        this.writeDocumentation(javaFile);
        this.writeSignature(javaFile.newLine().beginPublicMethod(), false, true).exceptions("OncRpcException", "IOException").endSignature();
    }

    public void writeServerStubDeclaration(JrpcgenJavaFile javaFile, JrpcgenContext context) {
        this.writeDocumentation(javaFile);
        this.writeSignature(javaFile.newLine().beginPublicAbstractMethod(), context.options().withCallInfo, false).endSignature().newLine();
    }

    public void writeServerStubMethodCall(JrpcgenJavaFile javaFile, final JrpcgenContext context) {
        JrpcgenJavaFile.Expression procedureCall;
        javaFile.elseBlock().append("case ").append(this.constant.getValueAsRValue(null)).println(": {");
        if (this.parameters == null) {
            javaFile.beginLine().append("call.retrieveCall(");
            JrpcgenBaseType.VOID.writeXdrConstructorCall(javaFile, (String)null);
            javaFile.rightParenthesis().semicolon().newLine();
            procedureCall = new JrpcgenJavaFile.Expression(){

                @Override
                public void writeTo(JrpcgenJavaFile javaFile) {
                    javaFile.append(JrpcgenProcedureInfo.this.procedureId).leftParenthesis();
                    if (context.options().withCallInfo) {
                        javaFile.append("call");
                    }
                    javaFile.rightParenthesis();
                }
            };
        } else {
            this.writeXdrRetrieveArgument(javaFile, "args$", context);
            javaFile.beginLine().println("call.retrieveCall(args$);");
            procedureCall = new JrpcgenJavaFile.Expression(){

                @Override
                public void writeTo(JrpcgenJavaFile javaFile) {
                    boolean parametersStarted = false;
                    javaFile.append(JrpcgenProcedureInfo.this.procedureId).leftParenthesis();
                    if (context.options().withCallInfo) {
                        javaFile.append("call");
                        parametersStarted = true;
                    }
                    if (JrpcgenProcedureInfo.this.parameters.size() == 1) {
                        JrpcgenParamInfo parameter = (JrpcgenParamInfo)JrpcgenProcedureInfo.this.parameters.getFirstItem();
                        if (parametersStarted) {
                            javaFile.append(", ");
                        }
                        parameter.getTypeInfo().writeXdrToJava(javaFile, "args$");
                    } else {
                        for (JrpcgenParamInfo parameter : JrpcgenProcedureInfo.this.parameters) {
                            if (parametersStarted) {
                                javaFile.append(", args$.").append(parameter.getName());
                                continue;
                            }
                            javaFile.append("args$.").append(parameter.getName());
                            parametersStarted = true;
                        }
                    }
                    javaFile.rightParenthesis();
                }
            };
        }
        if (this.resultTypeInfo.isVoid()) {
            javaFile.beginLine().expression(procedureCall).semicolon().beginNewLine().append("call.reply(");
            this.resultTypeInfo.writeXdrConstructorCall(javaFile, (String)null);
            javaFile.rightParenthesis().semicolon().newLine();
        } else {
            javaFile.beginLine().append(this.resultTypeInfo.getXdrClass()).space().append("result$ = ");
            this.resultTypeInfo.writeJavaToXdr(javaFile, procedureCall);
            javaFile.semicolon().beginNewLine().println("call.reply(result$);");
        }
        javaFile.beginLine().println("break;").elseBlock().println('}');
    }

    public void writeInterfaceDeclaration(JrpcgenJavaFile javaFile, JrpcgenContext context) {
        this.writeDocumentation(javaFile);
        this.writeSignature(javaFile.newLine().beginInterfaceMethod(), false, false).exceptions("OncRpcException", "IOException").endSignature().newLine();
    }

    public JrpcgenJavaFile.MethodSignature writeSignature(JrpcgenJavaFile.MethodSignature methodSignature, boolean withCallInfo, boolean finalParameters) {
        methodSignature.resultType(this.resultTypeInfo.getJavaName()).name(this.procedureId);
        if (withCallInfo) {
            methodSignature.parameter("OncRpcCallInformation", "call$");
        }
        if (this.parameters != null) {
            if (this.parameters.size() == 1) {
                ((JrpcgenParamInfo)this.parameters.getFirstItem()).writeMethodParameter(methodSignature);
            } else {
                for (JrpcgenParamInfo parameter : this.parameters) {
                    if (finalParameters) {
                        parameter.writeFinalMethodParameter(methodSignature);
                        continue;
                    }
                    parameter.writeMethodParameter(methodSignature);
                }
            }
        }
        return methodSignature;
    }

    public String writeXdrCallArgument(JrpcgenJavaFile javaFile, JrpcgenContext context) {
        String argumentName = null;
        if (this.parameters == null) {
            JrpcgenBaseType voidType = JrpcgenBaseType.VOID;
            argumentName = "args$";
            javaFile.beginLine().append(voidType.getXdrClass()).space().append(argumentName).append(" = ");
            voidType.writeXdrConstructorCall(javaFile, (String)null);
            javaFile.semicolon().newLine();
        } else if (this.parameters.size() == 1) {
            JrpcgenParamInfo parameter = (JrpcgenParamInfo)this.parameters.getFirstItem();
            argumentName = parameter.writeXdrCallArgument(javaFile, context);
        } else {
            argumentName = "args$";
            javaFile.beginBlock().append("XdrAble ").append(argumentName).println(" = new XdrAble() {");
            javaFile.beginPublicMethod().resultType("void").name("xdrEncode").parameter("XdrEncodingStream", "xdr").exceptions("OncRpcException", "IOException").endSignature();
            for (JrpcgenParamInfo parameter : this.parameters) {
                parameter.writeXdrEncodingCall(javaFile, "xdr");
            }
            javaFile.endMethod();
            javaFile.beginPublicMethod().resultType("void").name("xdrDecode").parameter("XdrDecodingStream", "xdr").exceptions("OncRpcException", "IOException").endSignature();
            javaFile.endMethod();
            javaFile.endBlock().println("};");
        }
        return argumentName;
    }

    public void writeXdrRetrieveArgument(JrpcgenJavaFile javaFile, String argumentName, JrpcgenContext context) {
        if (this.parameters.size() == 1) {
            JrpcgenTypeInfo typeInfo = ((JrpcgenParamInfo)this.parameters.getFirstItem()).getTypeInfo();
            javaFile.beginLine().append(typeInfo.getXdrClass()).space().append(argumentName).append(" = ");
            typeInfo.writeXdrConstructorCall(javaFile, (String)null);
            javaFile.semicolon().newLine();
        } else {
            javaFile.beginBlock().println("class XdrAble$ implements XdrAble {");
            for (JrpcgenParamInfo parameter : this.parameters) {
                parameter.appendAsDeclaration(javaFile.beginLine().append("public "));
            }
            javaFile.beginPublicMethod().resultType("void").name("xdrEncode").parameter("XdrEncodingStream", "xdr").exceptions("OncRpcException", "IOException").endSignature().endMethod();
            javaFile.beginPublicMethod().resultType("void").name("xdrDecode").parameter("XdrDecodingStream", "xdr").exceptions("OncRpcException", "IOException").endSignature();
            for (JrpcgenParamInfo parameter : this.parameters) {
                parameter.writeXdrDecodingCall(javaFile, "xdr");
            }
            javaFile.endMethod();
            javaFile.endBlock().println("};");
            javaFile.beginLine().append("XdrAble$ ").append(argumentName).println(" = new XdrAble$();");
        }
    }

    public void writeXdrResultArgument(JrpcgenJavaFile javaFile, String resultName) {
        javaFile.beginLine().append(this.resultTypeInfo.getXdrClass()).space().append(resultName).append(" = ");
        this.resultTypeInfo.writeXdrConstructorCall(javaFile, (String)null);
        javaFile.semicolon().newLine();
    }

    public void writeReturnStatement(JrpcgenJavaFile javaFile, String resultName) {
        if (!this.resultTypeInfo.isVoid()) {
            javaFile.beginLine().keywordReturn().space();
            this.resultTypeInfo.writeXdrToJava(javaFile, resultName);
            javaFile.semicolon().newLine();
        }
    }

    @Override
    public String getIdentifier() {
        return this.procedureId;
    }

    public <T extends Appendable> T dump(T appendable) {
        try {
            appendable.append("PROCEDURE ").append(this.resultTypeInfo.getDefinitionName()).append(" ").append(this.procedureId).append('(');
            if (this.parameters == null || this.parameters.isEmpty()) {
                appendable.append(JrpcgenBaseType.VOID.getDefinitionName());
            } else {
                Iterator parameterIterator = this.parameters.iterator();
                ((JrpcgenParamInfo)parameterIterator.next()).dump(appendable);
                while (parameterIterator.hasNext()) {
                    ((JrpcgenParamInfo)parameterIterator.next()).dump(appendable.append(", "));
                }
            }
            appendable.append(") = ").append(this.procedureNumber);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return appendable;
    }

    public static class Table
    extends JrpcgenItemTable<JrpcgenProcedureInfo> {
    }
}

