/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

import java.io.IOException;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenContext;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenItem;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenItemTable;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenJavaFile;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenTypeInfo;

class JrpcgenParamInfo
implements JrpcgenItem {
    private final JrpcgenTypeInfo typeInfo;
    private final String name;

    public JrpcgenParamInfo(JrpcgenTypeInfo typeInfo, String name) {
        this.typeInfo = typeInfo;
        this.name = name;
    }

    @Override
    public String getIdentifier() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.typeInfo.getDefinitionName();
    }

    public JrpcgenTypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public void writeMethodParameter(JrpcgenJavaFile javaFile) {
        javaFile.append(this.typeInfo.getJavaName()).space().append(this.name);
    }

    public void writeMethodParameter(JrpcgenJavaFile.MethodSignature methodSignature) {
        methodSignature.parameter(this.typeInfo.getJavaName(), this.name);
    }

    public void writeFinalMethodParameter(JrpcgenJavaFile.MethodSignature methodSignature) {
        methodSignature.parameterFinal(this.typeInfo.getJavaName(), this.name);
    }

    public String writeXdrCallArgument(JrpcgenJavaFile javaFile, JrpcgenContext context) {
        String argumentName = this.name;
        if (this.typeInfo.getJavaName().compareTo(this.typeInfo.getXdrClass()) != 0) {
            argumentName = "args$";
            javaFile.beginLine().append(this.typeInfo.getXdrClass()).space().append(argumentName).append(" = ");
            this.typeInfo.writeJavaToXdr(javaFile, this.name);
            javaFile.semicolon().newLine();
        }
        return argumentName;
    }

    public void writeXdrEncodingCall(JrpcgenJavaFile javaFile, String xdrStream) {
        if (this.typeInfo.isStringType()) {
            this.typeInfo.writeXdrDynamicVectorEncodingCall(javaFile.beginLine(), xdrStream, this.name);
        } else {
            this.typeInfo.writeXdrEncodingCall(javaFile.beginLine(), xdrStream, this.name);
        }
        javaFile.semicolon().newLine();
    }

    public void writeXdrDecodingCall(JrpcgenJavaFile javaFile, String xdrStream) {
        javaFile.beginLine().append(this.name).append(" = ");
        if (this.typeInfo.isStringType()) {
            this.typeInfo.writeXdrDynamicVectorDecodingCall(javaFile, xdrStream);
        } else {
            this.typeInfo.writeXdrDecodingCall(javaFile, xdrStream);
        }
        javaFile.semicolon().newLine();
    }

    public void appendAsDeclaration(JrpcgenJavaFile javaFile) {
        javaFile.append(this.typeInfo.getJavaName()).space().append(this.name).println(';');
    }

    public <T extends Appendable> T dump(T appendable) {
        try {
            appendable.append(this.typeInfo.getDefinitionName());
            if (this.name != null) {
                appendable.append(' ').append(this.name);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return appendable;
    }

    public static class Table
    extends JrpcgenItemTable<JrpcgenParamInfo> {
    }
}

