/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

import java.io.File;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class JrpcgenOptions {
    public String startDate = new SimpleDateFormat().format(new Date());
    public boolean noBackups = false;
    public boolean clampProgAndVers = true;
    public boolean withCallInfo = false;
    public boolean debug = false;
    public boolean verbose = false;
    public boolean parseOnly = false;
    public File destinationDir = new File(".");
    public String packageName = null;
    public String baseClassname = null;
    public boolean noClient = false;
    public boolean noServer = false;
    public String serverClass = null;
    public boolean noXdr = false;
    public boolean serverTcpOnly = false;
    public boolean serverUdpOnly = false;
    public String clientClass = null;
    public boolean makeSerializable = false;
    public boolean makeBean = false;
    public boolean initStrings = false;
    public boolean noToString = false;
    public boolean noEquals = false;
    public boolean noEnum = false;
    public boolean noValueCtor = false;

    public boolean javaEnumerationsEnabled() {
        return !this.noEnum;
    }

    public boolean generateToStringMethod() {
        return !this.noToString;
    }

    public boolean generateEqualsMethod() {
        return !this.noEquals;
    }

    public boolean generateValueConstructor() {
        return !this.noValueCtor;
    }

    public boolean generateJavaFiles() {
        return !this.parseOnly;
    }

    public boolean generateClientStub() {
        return this.generateJavaFiles() && !this.noClient;
    }

    public boolean generateServerStub() {
        return this.generateJavaFiles() && !this.noServer;
    }

    public boolean generateProgramConstants() {
        return this.generateClientStub() || this.generateServerStub();
    }

    public boolean generateXdrTypes() {
        return this.generateJavaFiles() && !this.noXdr;
    }

    public boolean generateTcpTransport() {
        return this.serverTcpOnly || !this.serverUdpOnly;
    }

    public boolean generateUdpTransport() {
        return this.serverUdpOnly || !this.serverTcpOnly;
    }

    public String toString() {
        return "JrpcgenOptions [startDate=" + this.startDate + ", noBackups=" + this.noBackups + ", clampProgAndVers=" + this.clampProgAndVers + ", withCallInfo=" + this.withCallInfo + ", debug=" + this.debug + ", verbose=" + this.verbose + ", parseOnly=" + this.parseOnly + ", destinationDir=" + this.destinationDir + ", packageName=" + this.packageName + ", baseClassname=" + this.baseClassname + ", noClient=" + this.noClient + ", noServer=" + this.noServer + ", serverClass=" + this.serverClass + ", noXdr=" + this.noXdr + ", serverTcpOnly=" + this.serverTcpOnly + ", serverUdpOnly=" + this.serverUdpOnly + ", clientClass=" + this.clientClass + ", makeSerializable=" + this.makeSerializable + ", makeBean=" + this.makeBean + ", initStrings=" + this.initStrings + ", noToString=" + this.noToString + ", noEquals=" + this.noEquals + ", noEnum=" + this.noEnum + ", noValueCtor=" + this.noValueCtor + "]";
    }

    public static void printOptions(PrintStream out) {
        out.println("  -c <classname>  specify class name of client proxy stub");
        out.println("  -d <dir>        specify directory where to place generated source code files");
        out.println("  -p <package>    specify package name for generated source code files");
        out.println("  -s <classname>  specify class name of server proxy stub");
        out.println("  -t              create TCP Server only");
        out.println("  -u              create UDP Server only");
        out.println("  -ser            tag generated XDR classes as serializable");
        out.println("  -bean           generate accessors for usage as bean, implies -ser");
        out.println("  -noclamp        do not clamp version number in client method stubs");
        out.println("  -withcallinfo   supply call information to server method stubs");
        out.println("  -initstrings    initialize all strings to be empty instead of null");
        out.println("  -nobackup       do not make backups of old source code files");
        out.println("  -noclient       do not create client proxy stub");
        out.println("  -noserver       do not create server proxy stub");
        out.println("  -noxdr          do not create XDR datatype classes");
        out.println("  -noToString     do not create toString() methods");
        out.println("  -noEquals       do not create equals(Object o) and hashCode() methods");
        out.println("  -noEnum         generate enumerations as interfaces instead of enums (legacy support)");
        out.println("  -noValueCtor    do not create value constructors");
        out.println("  -parseonly      parse x-file only but do not create source code files");
        out.println("  -verbose        enable verbose output about what jrpcgen is doing");
        out.println("  -version        print jrpcgen version and exit");
        out.println("  -debug          enables printing of diagnostic messages");
        out.println("  -? -help        print this help message and exit");
        out.println("  --              end options");
    }

    public Arguments newArguments(String[] arguments) {
        return new Arguments(arguments);
    }

    public JrpcgenOptions reset() {
        this.startDate = new SimpleDateFormat().format(new Date());
        this.noBackups = false;
        this.clampProgAndVers = true;
        this.withCallInfo = false;
        this.debug = false;
        this.verbose = false;
        this.parseOnly = false;
        this.destinationDir = new File(".");
        this.packageName = null;
        this.baseClassname = null;
        this.noClient = false;
        this.noServer = false;
        this.serverClass = null;
        this.noXdr = false;
        this.serverTcpOnly = false;
        this.serverUdpOnly = false;
        this.clientClass = null;
        this.makeSerializable = false;
        this.makeBean = false;
        this.initStrings = false;
        this.noToString = false;
        this.noEquals = false;
        this.noEnum = false;
        this.noValueCtor = false;
        return this;
    }

    public class Arguments {
        private String[] arguments;
        private int argumentIndex;

        public ParseResult parse(PrintStream out) {
            String arg;
            int argIdx;
            ParseResult result = ParseResult.VALID;
            String[] args = this.arguments;
            int argc = this.arguments.length;
            for (argIdx = 0; result == ParseResult.VALID && argIdx < argc && ((arg = args[argIdx]).length() <= 0 || arg.charAt(0) == '-'); ++argIdx) {
                if (arg.equals("-d")) {
                    if (++argIdx >= argc) {
                        out.println("jrpcgen: missing directory");
                        result = ParseResult.INVALID;
                    }
                    JrpcgenOptions.this.destinationDir = new File(args[argIdx]);
                    continue;
                }
                if (arg.equals("-package") || arg.equals("-p")) {
                    if (++argIdx >= argc) {
                        out.println("jrpcgen: missing package name");
                        result = ParseResult.INVALID;
                    }
                    JrpcgenOptions.this.packageName = args[argIdx];
                    continue;
                }
                if (arg.equals("-c")) {
                    if (++argIdx >= argc) {
                        out.println("jrpcgen: missing client class name");
                        result = ParseResult.INVALID;
                    }
                    JrpcgenOptions.this.clientClass = args[argIdx];
                    continue;
                }
                if (arg.equals("-s")) {
                    if (++argIdx >= argc) {
                        out.println("jrpcgen: missing server class name");
                        result = ParseResult.INVALID;
                    }
                    JrpcgenOptions.this.serverClass = args[argIdx];
                    continue;
                }
                if (arg.equals("-ser")) {
                    JrpcgenOptions.this.makeSerializable = true;
                    continue;
                }
                if (arg.equals("-bean")) {
                    JrpcgenOptions.this.makeSerializable = true;
                    JrpcgenOptions.this.makeBean = true;
                    continue;
                }
                if (arg.equals("-initstrings")) {
                    JrpcgenOptions.this.initStrings = true;
                    continue;
                }
                if (arg.equals("-noclamp")) {
                    JrpcgenOptions.this.clampProgAndVers = false;
                    continue;
                }
                if (arg.equals("-withcallinfo")) {
                    JrpcgenOptions.this.withCallInfo = true;
                    continue;
                }
                if (arg.equals("-debug")) {
                    JrpcgenOptions.this.debug = true;
                    continue;
                }
                if (arg.equals("-nobackup")) {
                    JrpcgenOptions.this.noBackups = true;
                    continue;
                }
                if (arg.equals("-noclient")) {
                    JrpcgenOptions.this.noClient = true;
                    continue;
                }
                if (arg.equals("-noserver")) {
                    JrpcgenOptions.this.noServer = true;
                    continue;
                }
                if (arg.equals("-noxdr")) {
                    JrpcgenOptions.this.noXdr = true;
                    continue;
                }
                if (arg.equals("-t")) {
                    JrpcgenOptions.this.serverTcpOnly = true;
                    continue;
                }
                if (arg.equals("-u")) {
                    JrpcgenOptions.this.serverUdpOnly = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-noToString")) {
                    JrpcgenOptions.this.noToString = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-noEquals")) {
                    JrpcgenOptions.this.noEquals = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-noEnum")) {
                    JrpcgenOptions.this.noEnum = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-noValueCtor")) {
                    JrpcgenOptions.this.noValueCtor = true;
                    continue;
                }
                if (arg.equals("-parseonly")) {
                    JrpcgenOptions.this.parseOnly = true;
                    continue;
                }
                if (arg.equals("-verbose")) {
                    JrpcgenOptions.this.verbose = true;
                    continue;
                }
                if (arg.equals("-version")) {
                    result = ParseResult.VERSION_REQUESTED;
                    continue;
                }
                if (arg.equals("-help") || arg.equals("-?")) {
                    result = ParseResult.HELP_REQUESTED;
                    continue;
                }
                if (arg.equals("--")) {
                    result = ParseResult.LAST;
                    continue;
                }
                out.println("Unrecognized option: " + arg);
                result = ParseResult.INVALID;
            }
            this.argumentIndex = argIdx;
            return result;
        }

        public String getXFilename() {
            if (this.argumentIndex == this.arguments.length - 1) {
                return this.arguments[this.argumentIndex++];
            }
            return null;
        }

        private Arguments(String[] arguments) {
            this.arguments = arguments;
            this.argumentIndex = 0;
        }
    }

    public static enum ParseResult {
        VALID,
        INVALID,
        HELP_REQUESTED,
        VERSION_REQUESTED,
        LAST;

    }
}

