/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenBaseType;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenComplexType;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenConst;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenContext;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenDeclaration;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenEnum;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenJavaFile;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenOptions;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenParamInfo;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenProcedureInfo;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenProgramInfo;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenStruct;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenTypeInfo;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenTypedefinition;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenUnion;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenUnionArm;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenVersionInfo;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenXdrDefinition;

public class JrpcgenModule {
    private final JrpcgenContext context;
    private final JrpcgenProgramInfo.Table programs = new JrpcgenProgramInfo.Table();

    public JrpcgenModule(JrpcgenContext context) {
        this.context = context;
    }

    JrpcgenProgramInfo.Table getProgramInfos() {
        return this.programs;
    }

    public JrpcgenConst addConstant(String identifier, String value) {
        JrpcgenConst newConstant = null;
        JrpcgenXdrDefinition.Table globalDefinitions = this.context.globalDefinitions();
        if (globalDefinitions.isUnknownIdentifier(identifier)) {
            newConstant = new JrpcgenConst(this.context, identifier, value, this.context.options().baseClassname);
            globalDefinitions.putItem(newConstant);
            if (this.context.options().debug) {
                newConstant.dump();
            }
        }
        return newConstant;
    }

    public JrpcgenConst addEnumerationElement(String identifier, String value) {
        JrpcgenEnum.Element newEnumerationElement = null;
        JrpcgenXdrDefinition.Table globalDefinitions = this.context.globalDefinitions();
        if (globalDefinitions.isUnknownIdentifier(identifier)) {
            newEnumerationElement = new JrpcgenEnum.Element(this.context, identifier, value);
            globalDefinitions.putItem(newEnumerationElement);
        }
        return newEnumerationElement;
    }

    public JrpcgenEnum addEnumeration(String identifier, JrpcgenConst.Table elements) {
        JrpcgenEnum newEnumeration = null;
        JrpcgenXdrDefinition.Table globalDefinitions = this.context.globalDefinitions();
        if (globalDefinitions.isUnknownIdentifier(identifier)) {
            newEnumeration = new JrpcgenEnum(this.context, identifier, elements);
            globalDefinitions.putItem(newEnumeration);
            if (this.context.options().debug) {
                newEnumeration.dump();
            }
        }
        return newEnumeration;
    }

    public JrpcgenTypedefinition addTypedefinition(JrpcgenDeclaration declaration) {
        JrpcgenTypedefinition newTypedefinition = null;
        JrpcgenXdrDefinition.Table globalDefinitions = this.context.globalDefinitions();
        if (declaration.getIdentifier().compareTo(declaration.getType()) != 0) {
            if (globalDefinitions.isUnknownIdentifier(declaration.getIdentifier())) {
                newTypedefinition = new JrpcgenTypedefinition(declaration, this.context);
                globalDefinitions.putItem(newTypedefinition);
                if (this.context.options().debug) {
                    newTypedefinition.dump();
                }
            }
        } else {
            JrpcgenXdrDefinition conflictingDefinition = (JrpcgenXdrDefinition)globalDefinitions.getItem(declaration.getType());
            newTypedefinition = new JrpcgenTypedefinition(declaration, this.context);
            if (conflictingDefinition == null) {
                System.out.println("WARNING: typedef alias '" + declaration.getType() + "' without previous definition of the type will be ignored");
            } else if (conflictingDefinition.isStruct()) {
                System.out.println("WARNING: typedef struct alias '" + declaration.getType() + "' will be ignored");
            } else if (conflictingDefinition.isEnum()) {
                System.out.println("WARNING: typedef enum alias '" + declaration.getType() + "' will be ignored");
            } else if (conflictingDefinition.isUnion()) {
                System.out.println("WARNING: typedef union alias '" + declaration.getType() + "' will be ignored");
            } else {
                System.out.println("WARNING: typedef alias '" + declaration.getType() + "' will be ignored");
            }
        }
        return newTypedefinition;
    }

    public JrpcgenStruct addStruct(String identifier, JrpcgenDeclaration.Table elements) {
        JrpcgenStruct newStruct = null;
        JrpcgenXdrDefinition.Table globalDefinitions = this.context.globalDefinitions();
        if (globalDefinitions.isUnknownIdentifier(identifier)) {
            newStruct = new JrpcgenStruct(this.context, identifier, elements);
            globalDefinitions.putItem(newStruct);
            if (this.context.options().debug) {
                newStruct.dump();
            }
        }
        return newStruct;
    }

    public JrpcgenUnion addUnion(String identifier, JrpcgenDeclaration discriminant, Vector<JrpcgenUnionArm> arms) {
        JrpcgenUnion newUnion = null;
        JrpcgenXdrDefinition.Table globalDefinitions = this.context.globalDefinitions();
        if (globalDefinitions.isUnknownIdentifier(identifier)) {
            newUnion = new JrpcgenUnion(this.context, identifier, discriminant, arms);
            globalDefinitions.putItem(newUnion);
            if (this.context.options().debug) {
                newUnion.dump();
            }
        }
        return newUnion;
    }

    public JrpcgenProgramInfo addProgramInfo(String programId, String programNumber, JrpcgenVersionInfo.Table versions) {
        JrpcgenProgramInfo newProgramInfo = null;
        JrpcgenXdrDefinition.Table globalDefinitions = this.context.globalDefinitions();
        if (globalDefinitions.isUnknownIdentifier(programId)) {
            JrpcgenConst programConstant = new JrpcgenConst(this.context, programId, programNumber, this.context.options().baseClassname);
            newProgramInfo = new JrpcgenProgramInfo(this.context, programId, programNumber, versions);
            programConstant.setDocumentation("/** service number of {@linkplain " + this.context.getInterfaceName(programId) + "}\n * value=" + programNumber + " */");
            globalDefinitions.putItem(programConstant);
            this.programs.putItem(newProgramInfo);
            if (this.context.options().debug) {
                newProgramInfo.dump();
            }
        }
        return newProgramInfo;
    }

    public JrpcgenDeclaration newScalarDeclaration(String identifier, String type) {
        return new JrpcgenDeclaration(identifier, JrpcgenTypeInfo.getTypeInfo(this.context, type));
    }

    public JrpcgenDeclaration newFixedVectorDeclaration(String identifier, String type, String size) {
        JrpcgenTypeInfo typeInfo = JrpcgenTypeInfo.getTypeInfo(this.context, type);
        if (!typeInfo.isBaseType()) {
            this.context.typesInFixedVectorUse().add(type);
        }
        return new JrpcgenDeclaration(identifier, JrpcgenTypeInfo.getTypeInfo(this.context, type), JrpcgenDeclaration.Kind.FIXEDVECTOR, size);
    }

    public JrpcgenDeclaration newDynamicVectorDeclaration(String identifier, String type, String size) {
        JrpcgenTypeInfo typeInfo = JrpcgenTypeInfo.getTypeInfo(this.context, type);
        if (!typeInfo.isBaseType()) {
            this.context.typesInDynamicVectorUse().add(type);
        }
        return new JrpcgenDeclaration(identifier, JrpcgenTypeInfo.getTypeInfo(this.context, type), JrpcgenDeclaration.Kind.DYNAMICVECTOR, size);
    }

    public JrpcgenDeclaration newIndirectionDeclaration(String identifier, String type) {
        return new JrpcgenDeclaration(identifier, JrpcgenTypeInfo.getTypeInfo(this.context, type), JrpcgenDeclaration.Kind.INDIRECTION, null);
    }

    public JrpcgenDeclaration newStringDeclaration(String identifier, String size) {
        return new JrpcgenDeclaration(identifier, JrpcgenBaseType.STRING, JrpcgenDeclaration.Kind.DYNAMICVECTOR, size);
    }

    public JrpcgenDeclaration newFixedOpaqueDeclaration(String identifier, String size) {
        return new JrpcgenDeclaration(identifier, JrpcgenBaseType.OPAQUE, JrpcgenDeclaration.Kind.FIXEDVECTOR, size);
    }

    public JrpcgenDeclaration newOpaqueDeclaration(String identifier, String size) {
        return new JrpcgenDeclaration(identifier, JrpcgenBaseType.OPAQUE, JrpcgenDeclaration.Kind.DYNAMICVECTOR, size);
    }

    public JrpcgenDeclaration newVoidDeclaration() {
        return new JrpcgenDeclaration(null, JrpcgenBaseType.VOID);
    }

    public JrpcgenVersionInfo newVersionInfo(String versionId, String versionNumber, JrpcgenProcedureInfo.Table procedures) {
        JrpcgenVersionInfo newVersionInfo = null;
        JrpcgenXdrDefinition.Table globalDefinitions = this.context.globalDefinitions();
        if (globalDefinitions.isUnknownIdentifier(versionId)) {
            JrpcgenConst versionConstant = new JrpcgenConst(this.context, versionId, versionNumber, this.context.options().baseClassname);
            newVersionInfo = new JrpcgenVersionInfo(this.context, versionId, versionNumber, procedures);
            globalDefinitions.putItem(versionConstant);
            newVersionInfo.resolvedVersionNumber = versionConstant.resolveValue();
            if (this.context.options().debug) {
                newVersionInfo.dump();
            }
        }
        return newVersionInfo;
    }

    public JrpcgenProcedureInfo newProcedureInfo(String jdoc, String procedureId, String procedureNumber, String resultType, JrpcgenParamInfo.Table parameters) {
        return new JrpcgenProcedureInfo(jdoc, procedureId, procedureNumber, JrpcgenTypeInfo.getTypeInfo(this.context, resultType), parameters);
    }

    public JrpcgenProcedureInfo newProcedureInfo(String procedureId, String procedureNumber, String resultType, JrpcgenParamInfo.Table parameters) {
        return new JrpcgenProcedureInfo(procedureId, procedureNumber, JrpcgenTypeInfo.getTypeInfo(this.context, resultType), parameters);
    }

    public JrpcgenParamInfo newParamInfo(String parameterType, String parameterName) {
        return new JrpcgenParamInfo(JrpcgenTypeInfo.getTypeInfo(this.context, parameterType), parameterName);
    }

    public void generateJavaFiles() {
        JrpcgenOptions options = this.context.options();
        if (!options.parseOnly) {
            if (options.generateProgramConstants()) {
                this.generateProgramConstants();
            }
            if (options.generateXdrTypes()) {
                Iterator<JrpcgenComplexType> complexTypeIterator = this.context.globalDefinitions().iterator(JrpcgenComplexType.class);
                while (complexTypeIterator.hasNext()) {
                    complexTypeIterator.next().generateJavaFile();
                }
            }
            if (options.generateClientStub() || options.generateServerStub()) {
                for (JrpcgenProgramInfo program : this.programs) {
                    program.writeProgramInterface();
                    if (options.generateClientStub()) {
                        program.writeClientStub();
                    }
                    if (!options.generateServerStub()) continue;
                    program.writeServerStub();
                }
            }
            JrpcgenTypeInfo.generateCodingSupplement(this.context);
        }
    }

    private void generateProgramConstants() {
        String baseClassname = this.context.options().baseClassname;
        try (JrpcgenJavaFile javaFile = JrpcgenJavaFile.open(baseClassname, this.context);){
            Iterator<JrpcgenConst> globalConstants = this.context.globalDefinitions().iterator(JrpcgenConst.class);
            javaFile.writeHeader(false);
            javaFile.append("/**").newLine().append(" * A collection of constants used by the \"").append(baseClassname).append("\" ONC/RPC program.").newLine().append(" */").newLine().beginTypedefinition("public interface ").append(baseClassname).println(" {");
            while (globalConstants.hasNext()) {
                JrpcgenConst globalConstant = globalConstants.next();
                if (!baseClassname.equals(globalConstant.getEnclosure())) continue;
                globalConstant.writeDeclaration(javaFile);
            }
            javaFile.newLine().endTypedefinition();
        }
        catch (IOException ioException) {
            System.err.println("Cannot close source code file: " + ioException.getLocalizedMessage());
        }
    }
}

