/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenContext;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenOptions;

public class JrpcgenJavaFile
implements Appendable,
Closeable {
    private static final String ACCESS_PUBLIC = "public";
    private static final String ACCESS_PROTECTED = "protected";
    private static final String ACCESS_PRIVATE = "private";
    private static final String TAB = "    ";
    private final JrpcgenContext context;
    private final String filename;
    private final Writer fileWriter;
    private final PrintWriter printWriter;
    private int tabStops;
    private int lineLength;

    public static JrpcgenJavaFile open(String classname, JrpcgenContext context) {
        JrpcgenJavaFile javaSourceFile = null;
        JrpcgenOptions options = context.options();
        String filename = classname + ".java";
        File file = new File(options.destinationDir, filename);
        if (options.debug) {
            System.out.println("Generating source code for \"" + filename + "\" in \"" + options.destinationDir + "\"");
        }
        if (file.exists() && !options.noBackups) {
            File oldBackup;
            if (!file.isFile()) {
                System.err.println("error: source file \"" + filename + "\"already exists and is not a regular file");
                System.exit(1);
            }
            if ((oldBackup = new File(options.destinationDir, filename + "~")).isFile()) {
                oldBackup.delete();
            } else if (oldBackup.exists()) {
                System.err.println("error: backup source file \"" + filename + "~\" is not a regular file");
                System.exit(1);
            }
            if (!file.renameTo(new File(options.destinationDir, filename + "~"))) {
                System.err.println("error: can not rename old source code file \"" + filename + "\"");
                System.exit(1);
            }
            if (options.verbose) {
                System.out.println("Saved old source code file as \"" + filename + "~\"");
            }
        }
        try {
            javaSourceFile = new JrpcgenJavaFile(context, filename, new FileWriter(file));
        }
        catch (IOException e) {
            System.err.println("error: can not create \"" + filename + "\": " + e.getLocalizedMessage());
            System.exit(1);
        }
        if (options.verbose) {
            System.out.print("Creating source code file \"" + filename + "\"...");
        }
        return javaSourceFile;
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public PrintWriter getPrintWriter() {
        return this.printWriter;
    }

    public JrpcgenJavaFile writeHeader(boolean emitImports) {
        PrintWriter out = this.printWriter;
        JrpcgenOptions options = this.context.options();
        out.println("/*");
        out.println(" * Automatically generated by jrpcgen " + this.context.getJrpcgenVersion() + " on " + options.startDate);
        out.println(" * jrpcgen is part of the \"Remote Tea\" ONC/RPC package for Java");
        out.println(" * See http://remotetea.sourceforge.net for details");
        out.println(" */");
        if (options.packageName != null && options.packageName.length() > 0) {
            out.println("package " + options.packageName + ";");
        }
        if (emitImports) {
            out.println("import org.acplt.oncrpc.*;");
            out.println("import java.io.IOException;");
            out.println();
        }
        return this;
    }

    @Override
    public JrpcgenJavaFile append(char character) {
        this.printWriter.append(character);
        ++this.lineLength;
        return this;
    }

    @Override
    public JrpcgenJavaFile append(CharSequence characterSequence) {
        this.printWriter.append(characterSequence);
        this.lineLength += characterSequence.length();
        return this;
    }

    @Override
    public JrpcgenJavaFile append(CharSequence characterSequence, int start, int end) {
        this.printWriter.append(characterSequence, start, end);
        this.lineLength += end - start;
        return this;
    }

    public JrpcgenJavaFile println(char character) {
        this.printWriter.println(character);
        return this;
    }

    public JrpcgenJavaFile println(CharSequence characterSequence) {
        this.printWriter.println(characterSequence);
        this.lineLength = 0;
        return this;
    }

    public JrpcgenJavaFile beginLine() {
        PrintWriter out = this.printWriter;
        int tabCount = this.tabStops;
        while (tabCount-- > 0) {
            out.print(TAB);
            this.lineLength += TAB.length();
        }
        return this;
    }

    public JrpcgenJavaFile newLine() {
        this.printWriter.println();
        this.lineLength = 0;
        return this;
    }

    public JrpcgenJavaFile beginNewLine() {
        return this.newLine().beginLine();
    }

    public JrpcgenJavaFile space() {
        this.append(' ');
        return this;
    }

    public JrpcgenJavaFile dot() {
        this.append('.');
        return this;
    }

    public JrpcgenJavaFile leftParenthesis() {
        this.append('(');
        return this;
    }

    public JrpcgenJavaFile rightParenthesis() {
        this.append(')');
        return this;
    }

    public JrpcgenJavaFile semicolon() {
        this.append(';');
        return this;
    }

    public JrpcgenJavaFile keywordNew() {
        this.append("new");
        return this;
    }

    public JrpcgenJavaFile keywordReturn() {
        this.append("return");
        return this;
    }

    public JrpcgenJavaFile expression(Expression expression) {
        expression.writeTo(this);
        return this;
    }

    public JrpcgenJavaFile beginTypedefinition(String definition) {
        this.beginLine().append(definition);
        ++this.tabStops;
        return this;
    }

    public void endTypedefinition() {
        --this.tabStops;
        this.printWriter.println('}');
    }

    public MethodSignature beginPublicConstructor(String name) {
        this.beginLine();
        return new MethodSignature().publicMethod().name(name);
    }

    public MethodSignature beginPrivateConstructor(String name) {
        this.beginLine();
        return new MethodSignature().privateMethod().name(name);
    }

    public MethodSignature beginPublicMethod() {
        this.beginLine();
        return new MethodSignature().publicMethod();
    }

    public MethodSignature beginPrivateMethod() {
        this.beginLine();
        return new MethodSignature().privateMethod();
    }

    public MethodSignature beginPublicAbstractMethod() {
        this.beginLine();
        return new MethodSignature().publicMethod().abstractMethod();
    }

    public MethodSignature beginInterfaceMethod() {
        this.beginLine();
        return new MethodSignature().interfaceMethod();
    }

    public void endMethod() {
        --this.tabStops;
        this.beginLine().println('}');
    }

    public JrpcgenJavaFile beginBlock() {
        this.beginLine();
        ++this.tabStops;
        return this;
    }

    public JrpcgenJavaFile elseBlock() {
        --this.tabStops;
        this.beginLine();
        ++this.tabStops;
        return this;
    }

    public JrpcgenJavaFile endBlock() {
        --this.tabStops;
        return this.beginLine();
    }

    public int getIndentationLength() {
        return this.tabStops * TAB.length();
    }

    @Override
    public void close() throws IOException {
        this.printWriter.println("// End of " + this.filename);
        if (this.context.options().verbose) {
            System.out.println();
        }
        this.printWriter.close();
        this.fileWriter.close();
    }

    private JrpcgenJavaFile(JrpcgenContext context, String filename, Writer fileWriter) {
        this.context = context;
        this.filename = filename;
        this.fileWriter = fileWriter;
        this.printWriter = new PrintWriter(fileWriter, true);
    }

    public class MethodSignature {
        private MethodSignatureStage stage = MethodSignatureStage.SIGNATURE_OPEN;
        private String access = "";
        boolean isAbstract;

        public MethodSignature publicMethod() {
            return this.access(JrpcgenJavaFile.ACCESS_PUBLIC);
        }

        public MethodSignature protectedMethod() {
            return this.access(JrpcgenJavaFile.ACCESS_PROTECTED);
        }

        public MethodSignature privateMethod() {
            return this.access(JrpcgenJavaFile.ACCESS_PRIVATE);
        }

        public MethodSignature abstractMethod() {
            switch (this.stage) {
                case ACCESS_WRITTEN: {
                    JrpcgenJavaFile.this.append("abstract ");
                    this.isAbstract = true;
                    this.stage = MethodSignatureStage.ABSTRACT_WRITTEN;
                    break;
                }
            }
            return this;
        }

        public MethodSignature interfaceMethod() {
            switch (this.stage) {
                case SIGNATURE_OPEN: {
                    this.isAbstract = true;
                    this.stage = MethodSignatureStage.ABSTRACT_WRITTEN;
                    break;
                }
            }
            return this;
        }

        public MethodSignature staticMethod() {
            switch (this.stage) {
                case ACCESS_WRITTEN: {
                    JrpcgenJavaFile.this.append("static ");
                    this.stage = MethodSignatureStage.STATIC_WRITTEN;
                    break;
                }
            }
            return this;
        }

        public MethodSignature resultType(String resultType) {
            switch (this.stage) {
                case ACCESS_WRITTEN: 
                case ABSTRACT_WRITTEN: 
                case STATIC_WRITTEN: {
                    JrpcgenJavaFile.this.append(resultType).space();
                    this.stage = MethodSignatureStage.RESULTTYPE_WRITTEN;
                    break;
                }
            }
            return this;
        }

        public MethodSignature resultType(String ... resultTypeFragments) {
            switch (this.stage) {
                case ACCESS_WRITTEN: 
                case ABSTRACT_WRITTEN: 
                case STATIC_WRITTEN: {
                    this.appendFragments(resultTypeFragments).space();
                    this.stage = MethodSignatureStage.RESULTTYPE_WRITTEN;
                    break;
                }
            }
            return this;
        }

        public MethodSignature name(String name) {
            switch (this.stage) {
                case ACCESS_WRITTEN: 
                case RESULTTYPE_WRITTEN: {
                    JrpcgenJavaFile.this.append(name).append('(');
                    this.stage = MethodSignatureStage.NAME_WRITTEN;
                    break;
                }
            }
            return this;
        }

        public MethodSignature parameter(String type, String name) {
            switch (this.stage) {
                case NAME_WRITTEN: {
                    JrpcgenJavaFile.this.append(type).space().append(name);
                    this.stage = MethodSignatureStage.PARAM_WRITTEN;
                    break;
                }
                case PARAM_WRITTEN: {
                    JrpcgenJavaFile.this.append(", ").append(type).space().append(name);
                    break;
                }
            }
            return this;
        }

        public MethodSignature parameterLineBreak(String type, String name, int lineLengthMax) {
            switch (this.stage) {
                case NAME_WRITTEN: {
                    if (lineLengthMax > 0 && JrpcgenJavaFile.this.lineLength + 1 + type.length() + name.length() > lineLengthMax) {
                        this.lineBreak().append(type).space().append(name);
                    } else {
                        JrpcgenJavaFile.this.append(type).space().append(name);
                    }
                    this.stage = MethodSignatureStage.PARAM_WRITTEN;
                    break;
                }
                case PARAM_WRITTEN: {
                    if (lineLengthMax > 0 && JrpcgenJavaFile.this.lineLength + 3 + type.length() + name.length() > lineLengthMax) {
                        JrpcgenJavaFile.this.append(',');
                        this.lineBreak().append(type).space().append(name);
                        break;
                    }
                    JrpcgenJavaFile.this.append(", ").append(type).space().append(name);
                    break;
                }
            }
            return this;
        }

        public MethodSignature parameterFinal(String type, String name) {
            switch (this.stage) {
                case NAME_WRITTEN: {
                    JrpcgenJavaFile.this.append("final ").append(type).append(' ').append(name);
                    this.stage = MethodSignatureStage.PARAM_WRITTEN;
                    break;
                }
                case PARAM_WRITTEN: {
                    JrpcgenJavaFile.this.append(", final ").append(type).append(' ').append(name);
                    break;
                }
            }
            return this;
        }

        public MethodSignature exception(String exception) {
            switch (this.stage) {
                case NAME_WRITTEN: 
                case PARAM_WRITTEN: {
                    JrpcgenJavaFile.this.append(')');
                    switch (this.access) {
                        case "public": 
                        case "protected": 
                        case "private": {
                            this.lineBreak().append("throws ").append(exception);
                            break;
                        }
                        default: {
                            JrpcgenJavaFile.this.append(" throws ").append(exception);
                        }
                    }
                    this.stage = MethodSignatureStage.EXCEPTION_WRITTEN;
                    break;
                }
                case EXCEPTION_WRITTEN: {
                    JrpcgenJavaFile.this.append(", ").append(exception);
                    break;
                }
            }
            return this;
        }

        public MethodSignature exceptions(String ... exceptions) {
            for (String exception : exceptions) {
                this.exception(exception);
            }
            return this;
        }

        public JrpcgenJavaFile endSignature() {
            switch (this.stage) {
                case NAME_WRITTEN: 
                case PARAM_WRITTEN: {
                    if (this.isAbstract) {
                        JrpcgenJavaFile.this.println(");");
                        break;
                    }
                    JrpcgenJavaFile.this.println(") {");
                    break;
                }
                case EXCEPTION_WRITTEN: {
                    if (this.isAbstract) {
                        JrpcgenJavaFile.this.println(';');
                        break;
                    }
                    JrpcgenJavaFile.this.println(" {");
                    break;
                }
            }
            this.stage = MethodSignatureStage.SIGNATURE_CLOSED;
            if (!this.isAbstract) {
                JrpcgenJavaFile.this.tabStops++;
            }
            return JrpcgenJavaFile.this;
        }

        private MethodSignature access(String access) {
            switch (this.stage) {
                case SIGNATURE_OPEN: {
                    this.access = access;
                    JrpcgenJavaFile.this.append(access).append(' ');
                    this.stage = MethodSignatureStage.ACCESS_WRITTEN;
                    break;
                }
            }
            return this;
        }

        private JrpcgenJavaFile appendFragments(String[] fragments) {
            for (String fragment : fragments) {
                JrpcgenJavaFile.this.append(fragment);
            }
            return JrpcgenJavaFile.this;
        }

        private JrpcgenJavaFile lineBreak() {
            switch (this.access) {
                case "public": {
                    JrpcgenJavaFile.this.beginNewLine().append("       ");
                    break;
                }
                case "protected": {
                    JrpcgenJavaFile.this.beginNewLine().append("          ");
                    break;
                }
                case "private": {
                    JrpcgenJavaFile.this.beginNewLine().append("        ");
                    break;
                }
                default: {
                    JrpcgenJavaFile.this.beginNewLine().append(JrpcgenJavaFile.TAB);
                }
            }
            return JrpcgenJavaFile.this;
        }
    }

    public static enum MethodSignatureStage {
        SIGNATURE_OPEN,
        ACCESS_WRITTEN,
        STATIC_WRITTEN,
        ABSTRACT_WRITTEN,
        RESULTTYPE_WRITTEN,
        NAME_WRITTEN,
        PARAM_WRITTEN,
        EXCEPTION_WRITTEN,
        SIGNATURE_CLOSED;

    }

    public static interface Expression {
        public void writeTo(JrpcgenJavaFile var1);
    }
}

