/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenItem;

public class JrpcgenItemTable<T extends JrpcgenItem>
implements Iterable<T> {
    private final Map<String, T> table = new HashMap<String, T>();
    private final LinkedList<T> list = new LinkedList();

    public List<T> getItemList() {
        return this.list;
    }

    public void clear() {
        this.list.clear();
        this.table.clear();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public int size() {
        return this.list.size();
    }

    public boolean isUnknownIdentifier(String identifier) {
        return !this.table.containsKey(identifier);
    }

    public boolean addItem(T item) {
        boolean added = false;
        if (this.isUnknownIdentifier(item.getIdentifier())) {
            this.putItem(item);
            added = true;
        }
        return added;
    }

    public void putItem(T item) {
        JrpcgenItem previousItem = (JrpcgenItem)this.table.put(item.getIdentifier(), item);
        if (previousItem != null) {
            this.table.put(item.getIdentifier(), previousItem);
            throw new IllegalArgumentException("Identifier '" + item.getIdentifier() + "' is already known to this table.");
        }
        this.list.add(item);
    }

    public T getItem(String identifier) {
        return (T)((JrpcgenItem)this.table.get(identifier));
    }

    public <U extends JrpcgenItem> U getItem(Class<U> clazz, String identifier) {
        JrpcgenItem requestedItem = null;
        JrpcgenItem item = (JrpcgenItem)this.table.get(identifier);
        if (item != null && clazz.isInstance(item)) {
            requestedItem = (JrpcgenItem)clazz.cast(item);
        }
        return (U)requestedItem;
    }

    public T getFirstItem() {
        if (this.list.isEmpty()) {
            return null;
        }
        return (T)((JrpcgenItem)this.list.getFirst());
    }

    public T getLastItem() {
        if (this.list.isEmpty()) {
            return null;
        }
        return (T)((JrpcgenItem)this.list.getLast());
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    public <U extends JrpcgenItem> Iterator<U> iterator(Class<U> clazz) {
        Iterator itemIterator = this.list.iterator();
        JrpcgenItem firstItem = null;
        while (firstItem == null && itemIterator.hasNext()) {
            JrpcgenItem item = (JrpcgenItem)itemIterator.next();
            if (!clazz.isInstance(item)) continue;
            firstItem = (JrpcgenItem)clazz.cast(item);
        }
        return this.iterator(clazz, itemIterator, firstItem);
    }

    private <U extends JrpcgenItem> Iterator<U> iterator(final Class<U> clazz, final Iterator<T> itemIterator, final U firstItem) {
        return new Iterator<U>(){
            private U nextItem;
            {
                this.nextItem = firstItem;
            }

            @Override
            public boolean hasNext() {
                return this.nextItem != null;
            }

            @Override
            public U next() {
                Object currentDefinition = this.nextItem;
                if (currentDefinition != null) {
                    this.nextItem = null;
                    while (this.nextItem == null && itemIterator.hasNext()) {
                        JrpcgenItem item = (JrpcgenItem)itemIterator.next();
                        if (!clazz.isInstance(item)) continue;
                        this.nextItem = (JrpcgenItem)clazz.cast(item);
                    }
                }
                return currentDefinition;
            }

            @Override
            public void remove() {
                throw new RuntimeException("Method remove() is not available with this iterator.");
            }
        };
    }
}

