/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

import java.io.IOException;
import java.util.Iterator;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenBaseType;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenComplexType;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenConst;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenContext;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenJavaFile;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenXdrDefinition;

public class JrpcgenEnum
extends JrpcgenComplexType {
    private final JrpcgenContext context;
    private final JrpcgenConst.Table elements;
    private final String javaName;
    private final String xdrClass;

    public JrpcgenEnum(JrpcgenContext context, String identifier, JrpcgenConst.Table elements) {
        super(identifier, JrpcgenXdrDefinition.Type.ENUM);
        Iterator elementIterator = elements.iterator();
        while (elementIterator.hasNext()) {
            ((JrpcgenConst)elementIterator.next()).setEnclosure(identifier);
        }
        this.context = context;
        this.elements = elements;
        this.javaName = context.options().javaEnumerationsEnabled() ? this.getIdentifier() : JrpcgenBaseType.INT.getJavaName();
        this.xdrClass = context.options().javaEnumerationsEnabled() ? "XdrEnum<" + this.getIdentifier() + ">" : JrpcgenBaseType.INT.getXdrClass();
    }

    public final JrpcgenConst.Table getElements() {
        return this.elements;
    }

    @Override
    public void generateJavaFile() {
        try (JrpcgenJavaFile javaFile = JrpcgenJavaFile.open(this.getIdentifier(), this.context);){
            if (this.context.options().noEnum) {
                this.writeInterface(this.context, javaFile);
            } else {
                this.writeEnumeration(this.context, javaFile);
            }
        }
        catch (IOException ioException) {
            System.err.println("Cannot close source code file: " + ioException.getLocalizedMessage());
        }
    }

    @Override
    public void writeXdrVectorCodingMethods(JrpcgenJavaFile javaFile, JrpcgenContext context) {
        if (context.options().javaEnumerationsEnabled()) {
            super.writeXdrVectorCodingMethods(javaFile, context);
        }
    }

    @Override
    public String getJavaName() {
        return this.javaName;
    }

    @Override
    public String getJavaClass() {
        if (this.context.options().javaEnumerationsEnabled()) {
            return this.javaName;
        }
        return JrpcgenBaseType.INT.getJavaClass();
    }

    @Override
    public String getXdrClass() {
        return this.xdrClass;
    }

    @Override
    public void writeXdrConstructorCall(JrpcgenJavaFile javaFile, String constructorParameter) {
        super.writeXdrConstructorCall(javaFile, constructorParameter == null ? ((JrpcgenConst)this.elements.getFirstItem()).getForEnclosure(null) : constructorParameter);
    }

    @Override
    public void writeJavaToXdr(JrpcgenJavaFile javaFile, String variable) {
        this.writeXdrConstructorCall(javaFile, variable);
    }

    @Override
    public void writeJavaToXdr(JrpcgenJavaFile javaFile, JrpcgenJavaFile.Expression expression) {
        this.writeXdrConstructorCall(javaFile, expression);
    }

    @Override
    public void writeXdrToJava(JrpcgenJavaFile javaFile, String result) {
        if (this.context.options().javaEnumerationsEnabled()) {
            javaFile.append(result).append(".getValue()");
        } else {
            JrpcgenBaseType.INT.writeXdrToJava(javaFile, result);
        }
    }

    @Override
    public void writeXdrEncodingCall(JrpcgenJavaFile javaFile, String xdrStream, String variable) {
        if (this.context.options().javaEnumerationsEnabled()) {
            JrpcgenBaseType.INT.writeXdrEncodingCall(javaFile, xdrStream, variable.concat(".getEncoding()"));
        } else {
            JrpcgenBaseType.INT.writeXdrEncodingCall(javaFile, xdrStream, variable);
        }
    }

    @Override
    public void writeXdrFixedVectorEncodingCall(JrpcgenJavaFile javaFile, String xdrStream, String variable, String size) {
        if (this.context.options().javaEnumerationsEnabled()) {
            super.writeXdrFixedVectorEncodingCall(javaFile, xdrStream, variable, size);
        } else {
            JrpcgenBaseType.INT.writeXdrFixedVectorEncodingCall(javaFile, xdrStream, variable, size);
        }
    }

    @Override
    public void writeXdrDynamicVectorEncodingCall(JrpcgenJavaFile javaFile, String xdrStream, String variable) {
        if (this.context.options().javaEnumerationsEnabled()) {
            super.writeXdrDynamicVectorEncodingCall(javaFile, xdrStream, variable);
        } else {
            JrpcgenBaseType.INT.writeXdrDynamicVectorEncodingCall(javaFile, xdrStream, variable);
        }
    }

    @Override
    public void writeXdrDecodingCall(JrpcgenJavaFile javaFile, String xdrStream) {
        if (this.context.options().javaEnumerationsEnabled()) {
            javaFile.append("XdrEnum.create(").append(((JrpcgenConst)this.elements.getFirstItem()).getForEnclosure(null)).append(", ").append(xdrStream).rightParenthesis();
        } else {
            JrpcgenBaseType.INT.writeXdrDecodingCall(javaFile, xdrStream);
        }
    }

    @Override
    public void writeXdrFixedVectorDecodingCall(JrpcgenJavaFile javaFile, String xdrStream, String size) {
        if (this.context.options().javaEnumerationsEnabled()) {
            super.writeXdrFixedVectorDecodingCall(javaFile, xdrStream, size);
        } else {
            JrpcgenBaseType.INT.writeXdrFixedVectorDecodingCall(javaFile, xdrStream, size);
        }
    }

    @Override
    public void writeXdrDynamicVectorDecodingCall(JrpcgenJavaFile javaFile, String xdrStream) {
        if (this.context.options().javaEnumerationsEnabled()) {
            super.writeXdrDynamicVectorDecodingCall(javaFile, xdrStream);
        } else {
            JrpcgenBaseType.INT.writeXdrDynamicVectorDecodingCall(javaFile, xdrStream);
        }
    }

    @Override
    public void writeEqualsExpression(JrpcgenJavaFile javaFile, String variableLeft, String variableRight, boolean negate) {
        if (this.context.options().javaEnumerationsEnabled()) {
            super.writeEqualsExpression(javaFile, variableLeft, variableRight, negate);
        } else {
            JrpcgenBaseType.INT.writeEqualsExpression(javaFile, variableLeft, variableRight, negate);
        }
    }

    public String toString() {
        return this.dump(new StringBuilder()).toString();
    }

    public void dump() {
        this.dump(System.out).println();
    }

    public <T extends Appendable> T dump(T appendable) {
        try {
            appendable.append("ENUM ").append(this.getIdentifier()).append(JrpcgenContext.newline());
            for (JrpcgenConst element : this.elements.getItemList()) {
                element.dump(appendable.append("  ")).append(JrpcgenContext.newline());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return appendable;
    }

    private void writeEnumeration(JrpcgenContext context, JrpcgenJavaFile javaFile) {
        if (context.typesInDynamicVectorUse().contains(this.getIdentifier()) || context.typesInFixedVectorUse().contains(this.getIdentifier())) {
            javaFile.writeHeader(true);
        } else {
            javaFile.writeHeader(false);
        }
        javaFile.beginLine().println("import org.acplt.oncrpc.HasEncoding;");
        this.writeDocumentation(javaFile.newLine());
        javaFile.newLine().beginTypedefinition("public enum ").append(this.getIdentifier()).append(" implements HasEncoding<").append(this.getIdentifier()).println("> {");
        for (JrpcgenConst element : this.elements.getItemList()) {
            element.writeDeclaration(javaFile);
            if (element != this.elements.getLastItem()) {
                javaFile.append(',').newLine();
                continue;
            }
            javaFile.append(';').newLine();
        }
        javaFile.newLine().beginLine().println("private final int encoding;");
        javaFile.newLine().beginPrivateConstructor(this.getIdentifier()).parameter("int", "encoding").endSignature();
        javaFile.beginLine().println("this.encoding = encoding;");
        javaFile.endMethod();
        javaFile.newLine().beginPublicMethod().resultType("int").name("getEncoding").endSignature();
        javaFile.beginLine().println("return encoding;");
        javaFile.endMethod();
        javaFile.newLine().beginPublicMethod().resultType("HasEncoding<", this.getIdentifier(), ">[]").name("getValues").endSignature();
        javaFile.beginLine().println("return values();");
        javaFile.endMethod();
        this.writeXdrVectorCodingMethods(javaFile, context);
        javaFile.newLine().endTypedefinition();
    }

    private void writeInterface(JrpcgenContext context, JrpcgenJavaFile javaFile) {
        javaFile.writeHeader(false);
        this.writeDocumentation(javaFile.newLine());
        javaFile.newLine().beginTypedefinition("public interface ").append(this.getIdentifier()).println(" {");
        for (JrpcgenConst element : this.elements.getItemList()) {
            element.writeDeclaration(javaFile);
        }
        javaFile.endTypedefinition();
    }

    public static class Element
    extends JrpcgenConst {
        public Element(JrpcgenContext context, String identifier, String value) {
            super(context, identifier, value);
        }

        @Override
        public void writeDeclaration(JrpcgenJavaFile javaFile) {
            if (this.javaEnumerationsEnabled()) {
                this.writeDocumentation(javaFile);
                javaFile.newLine().beginLine().append(this.getIdentifier()).append('(').append(this.getValueAsRValue(this.getEnclosure())).append(')');
            } else {
                super.writeDeclaration(javaFile);
            }
        }

        @Override
        public String getAsRValue(String forEnclosure) {
            String asRValue = super.getAsRValue(forEnclosure);
            if (this.javaEnumerationsEnabled()) {
                return asRValue.concat(".getEncoding()");
            }
            return asRValue;
        }

        @Override
        public String getAsCaseValue(String forEnclosure) {
            if (this.javaEnumerationsEnabled()) {
                return this.getIdentifier();
            }
            return super.getAsCaseValue(forEnclosure);
        }

        private boolean javaEnumerationsEnabled() {
            return this.getContext().options().javaEnumerationsEnabled();
        }
    }
}

