/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

import java.io.IOException;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenJavaFile;

public class JrpcgenDocumentable {
    protected String documentation;
    static String eol = System.getProperty("line.separator");

    public static String emptyDocumentation() {
        return "/** TODO */";
    }

    public JrpcgenDocumentable() {
        this(JrpcgenDocumentable.emptyDocumentation());
    }

    public JrpcgenDocumentable(String jdoc) {
        this.documentation = JrpcgenDocumentable.getNormalizedDocumentation(jdoc);
    }

    public boolean documentationIsEmpty() {
        return JrpcgenDocumentable.emptyDocumentation().equals(this.documentation);
    }

    public boolean documentationIsProvided() {
        return JrpcgenDocumentable.emptyDocumentation().compareTo(this.documentation) != 0;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    void setDocumentation(String jdoc) {
        this.documentation = JrpcgenDocumentable.getNormalizedDocumentation(jdoc);
    }

    public String getIdentedDocu(String prefix) {
        return this.getIdentedDocu(prefix, true);
    }

    public String getIdentedDocu(String prefix, boolean isWithDeprecatedAnnotation) {
        StringBuilder sb = new StringBuilder();
        String[] sa = this.documentation.split("\n|\r\n");
        for (int i = 0; i < sa.length; ++i) {
            if (i == 0) {
                sb.append(prefix).append(sa[0]);
            } else {
                int istar = sa[i].indexOf(42);
                if (istar >= 0) {
                    sb.append(prefix).append(' ').append(sa[i].substring(istar));
                } else {
                    sb.append(prefix).append(sa[i]);
                }
            }
            if (i >= sa.length - 1) continue;
            sb.append(eol);
        }
        if (isWithDeprecatedAnnotation) {
            this.appendDeprecatedOrNothing(sb, prefix);
        }
        return sb.toString();
    }

    public void writeDocumentation(JrpcgenJavaFile javaFile) {
        this.writeDocumentation(javaFile, true);
    }

    public void writeDocumentation(JrpcgenJavaFile javaFile, boolean isWithDeprecatedAnnotation) {
        String[] sa = this.documentation.split("\n|\r\n");
        for (int i = 0; i < sa.length; ++i) {
            if (i == 0) {
                javaFile.beginLine().append(sa[0]);
                continue;
            }
            int istar = sa[i].indexOf(42);
            if (istar >= 0) {
                javaFile.beginNewLine().append(' ').append(sa[i].substring(istar));
                continue;
            }
            javaFile.beginNewLine().append(sa[i]);
        }
        if (isWithDeprecatedAnnotation && this.isDeprecated()) {
            javaFile.beginNewLine().append("@Deprecated");
        }
    }

    protected void appendDeprecatedOrNothing(JrpcgenJavaFile javaFile) {
        if (this.isDeprecated()) {
            javaFile.beginNewLine().append("@Deprecated");
        }
    }

    protected Appendable appendDeprecatedOrNothing(Appendable p, String prefix) {
        if (this.isDeprecated()) {
            try {
                p.append(eol).append(prefix).append("@Deprecated");
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        return p;
    }

    protected boolean isDeprecated() {
        return this.documentation.contains("@deprecated");
    }

    private static String getNormalizedDocumentation(String jdoc) {
        if (JrpcgenDocumentable.emptyDocumentation().equals(jdoc) || jdoc == null || jdoc.isEmpty()) {
            return JrpcgenDocumentable.emptyDocumentation();
        }
        return jdoc;
    }
}

