/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

import java.io.IOException;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenBaseType;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenConst;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenContext;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenDocumentable;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenItem;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenItemTable;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenJavaFile;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenSHA;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenTypeMapping;

public class JrpcgenDeclaration
extends JrpcgenDocumentable
implements JrpcgenItem,
Cloneable {
    private final String identifier;
    private final JrpcgenTypeMapping typeMapping;
    private final Kind kind;
    private final String size;
    private String javaType;

    public JrpcgenDeclaration(String identifier, JrpcgenTypeMapping typeMapping) {
        this(identifier, typeMapping, Kind.SCALAR, null);
    }

    public JrpcgenDeclaration(String identifier, JrpcgenTypeMapping typeMapping, Kind kind, String size) {
        this.identifier = identifier;
        this.typeMapping = typeMapping;
        this.kind = kind;
        this.size = size;
    }

    @Override
    public final String getIdentifier() {
        return this.identifier;
    }

    public final String getType() {
        return this.typeMapping.getDefinitionName();
    }

    public final String getJavaType() {
        if (this.javaType == null) {
            if (this.typeMapping.isStringType()) {
                return this.typeMapping.getJavaName();
            }
            switch (this.kind) {
                case SCALAR: {
                    this.javaType = this.typeMapping.getJavaName();
                    break;
                }
                case FIXEDVECTOR: {
                    this.javaType = this.typeMapping.getJavaName().concat("[]");
                    break;
                }
                case DYNAMICVECTOR: {
                    if (this.typeMapping.isStringType()) {
                        this.javaType = this.typeMapping.getJavaName();
                        break;
                    }
                    this.javaType = this.typeMapping.getJavaName().concat("[]");
                    break;
                }
                case INDIRECTION: {
                    this.javaType = this.typeMapping.getJavaClass();
                }
            }
        }
        return this.javaType;
    }

    public final JrpcgenTypeMapping getTypeMapping() {
        return this.typeMapping;
    }

    public final Kind getKind() {
        return this.kind;
    }

    public final String getSize() {
        return this.size;
    }

    public void updateHash(JrpcgenSHA hash) {
        hash.update(this.typeMapping.getDefinitionName());
        hash.update(this.kind.ordinal());
        hash.update(this.identifier);
    }

    public void writeMemberDeclaration(JrpcgenJavaFile javaFile, String access, boolean initString) {
        this.writeDocumentation(javaFile);
        javaFile.newLine().beginLine().append(access).space().append(this.getJavaType()).space().append(this.identifier);
        if (initString && this.typeMapping.isStringType()) {
            javaFile.println(" = \"\";");
        } else {
            javaFile.semicolon().newLine();
        }
    }

    public void writeGettersAndSetters(JrpcgenJavaFile javaFile) {
        String jbName = this.getIdentifier().substring(0, 1).toUpperCase() + this.getIdentifier().substring(1);
        String getterName = "get".concat(jbName);
        String setterName = "set".concat(jbName);
        if (this.isArray()) {
            javaFile.beginPublicMethod().resultType("void").name(setterName).parameter(this.getJavaType(), this.identifier).endSignature().beginLine().append("this").dot().append(this.identifier).append(" = ").append(this.identifier).semicolon().newLine().endMethod();
            javaFile.beginPublicMethod().resultType("void").name(setterName).parameter("int", "index").parameter(this.typeMapping.getJavaName(), this.identifier.concat("Element")).endSignature().beginLine().append("this").dot().append(this.identifier).append("[index] = ").append(this.identifier).append("Element").semicolon().newLine().endMethod();
            javaFile.beginPublicMethod().resultType(this.getJavaType()).name(getterName).endSignature().beginLine().keywordReturn().space().append("this").dot().append(this.identifier).semicolon().newLine().endMethod();
            javaFile.beginPublicMethod().resultType(this.typeMapping.getJavaName()).name(getterName).parameter("int", "index").endSignature().beginLine().keywordReturn().space().append("this").dot().append(this.identifier).println("[index];").endMethod();
        } else {
            javaFile.beginPublicMethod().resultType("void").name(setterName).parameter(this.getJavaType(), this.identifier).endSignature().beginLine().append("this").dot().append(this.identifier).append(" = ").append(this.identifier).semicolon().newLine().endMethod();
            javaFile.beginPublicMethod().resultType(this.getJavaType()).name(getterName).endSignature().beginLine().keywordReturn().space().append("this").dot().append(this.identifier).semicolon().newLine().endMethod();
        }
    }

    public void writeEncodingPart(JrpcgenJavaFile javaFile, String enclosure, JrpcgenContext context) {
        this.writeEncodingPart(javaFile, enclosure, null, context);
    }

    public void writeEncodingPart(JrpcgenJavaFile javaFile, String enclosure, String oref, JrpcgenContext context) {
        if (!this.typeMapping.isVoid()) {
            final String variable = oref == null ? this.identifier : "" + oref + "." + this.identifier;
            String xdrStream = "xdr";
            switch (this.kind) {
                case SCALAR: {
                    this.typeMapping.writeXdrEncodingCall(javaFile.beginLine(), "xdr", variable);
                    javaFile.semicolon().newLine();
                    break;
                }
                case FIXEDVECTOR: {
                    this.typeMapping.writeXdrFixedVectorEncodingCall(javaFile.beginLine(), "xdr", variable, JrpcgenConst.getAsRValue(this.size, context));
                    javaFile.semicolon().newLine();
                    break;
                }
                case DYNAMICVECTOR: {
                    this.typeMapping.writeXdrDynamicVectorEncodingCall(javaFile.beginLine(), "xdr", variable);
                    javaFile.semicolon().newLine();
                    break;
                }
                case INDIRECTION: {
                    JrpcgenBaseType.BOOL.writeXdrEncodingCall(javaFile.beginLine(), "xdr", new JrpcgenJavaFile.Expression(){

                        @Override
                        public void writeTo(JrpcgenJavaFile javaFile) {
                            javaFile.append(variable).append(" != null");
                        }
                    });
                    javaFile.semicolon().beginNewLine().append("if (").append(variable).append(" != null) ");
                    this.typeMapping.writeXdrEncodingCall(javaFile, "xdr", variable);
                    javaFile.semicolon().newLine();
                }
            }
        }
    }

    public void writeDecodingPart(JrpcgenJavaFile javaFile, String enclosure, JrpcgenContext context) {
        this.writeDecodingPart(javaFile, enclosure, null, context);
    }

    public void writeDecodingPart(JrpcgenJavaFile javaFile, String enclosure, String oref, JrpcgenContext context) {
        if (!this.typeMapping.isVoid()) {
            String variable = oref == null ? this.identifier : "" + oref + "." + this.identifier;
            String xdrStream = "xdr";
            switch (this.kind) {
                case SCALAR: {
                    javaFile.beginLine().append(variable).append(" = ");
                    this.typeMapping.writeXdrDecodingCall(javaFile, "xdr");
                    javaFile.semicolon().newLine();
                    break;
                }
                case FIXEDVECTOR: {
                    javaFile.beginLine().append(variable).append(" = ");
                    this.typeMapping.writeXdrFixedVectorDecodingCall(javaFile, "xdr", JrpcgenConst.getAsRValue(this.size, context));
                    javaFile.semicolon().newLine();
                    break;
                }
                case DYNAMICVECTOR: {
                    javaFile.beginLine().append(variable).append(" = ");
                    this.typeMapping.writeXdrDynamicVectorDecodingCall(javaFile, "xdr");
                    javaFile.semicolon().newLine();
                    break;
                }
                case INDIRECTION: {
                    javaFile.beginLine().append(variable).append(" = ");
                    JrpcgenBaseType.BOOL.writeXdrDecodingCall(javaFile, "xdr");
                    javaFile.append(" ? ");
                    this.typeMapping.writeXdrDecodingCall(javaFile, "xdr");
                    javaFile.println(" : null;");
                }
            }
        }
    }

    public void writeToStringPart(JrpcgenJavaFile javaFile) {
        if (this.isArray()) {
            javaFile.beginLine().append("+ \"").append(this.identifier).append("=\" + java.util.Arrays.toString(").append(this.identifier).append(')');
        } else {
            javaFile.beginLine().append("+ \"").append(this.identifier).append("=\" + ").append(this.identifier);
        }
    }

    public void writeEqualsPart(JrpcgenJavaFile javaFile, JrpcgenContext context) {
        javaFile.beginLine().append("if (");
        this.writeEqualsExpression(javaFile, true, context);
        javaFile.append(") return false;").newLine();
    }

    public void writeEqualsExpression(JrpcgenJavaFile javaFile, boolean negate, JrpcgenContext context) {
        if (this.isArray()) {
            javaFile.append(negate ? "! " : "").append("java.util.Arrays.equals(this.").append(this.identifier).append(", other.").append(this.identifier).append(')');
        } else if (Kind.INDIRECTION.equals((Object)this.kind)) {
            javaFile.append(negate ? "! " : "").append("java.util.Objects.equals(this.").append(this.identifier).append(", other.").append(this.identifier).rightParenthesis();
        } else {
            this.typeMapping.writeEqualsExpression(javaFile, "this.".concat(this.identifier), "other.".concat(this.identifier), negate);
        }
    }

    public String toString() {
        return this.dump(new StringBuilder()).toString();
    }

    public void dump() {
        this.dump(System.out).println();
    }

    public <T extends Appendable> T dump(T appendable) {
        try {
            appendable.append(this.typeMapping.getDefinitionName()).append(Kind.INDIRECTION.equals((Object)this.kind) ? " *" : " ").append(this.identifier);
            switch (this.kind) {
                case FIXEDVECTOR: {
                    appendable.append('[').append(this.size).append(']');
                    break;
                }
                case DYNAMICVECTOR: {
                    if (this.size == null) {
                        appendable.append("<>");
                        break;
                    }
                    appendable.append('<').append(this.size).append('>');
                    break;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return appendable;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isArray() {
        return (Kind.FIXEDVECTOR.equals((Object)this.kind) || Kind.DYNAMICVECTOR.equals((Object)this.kind)) && !this.typeMapping.isStringType();
    }

    public static enum Kind {
        SCALAR,
        FIXEDVECTOR,
        DYNAMICVECTOR,
        INDIRECTION;

    }

    public static class Table
    extends JrpcgenItemTable<JrpcgenDeclaration> {
    }
}

