/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenConst;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenOptions;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenSHA;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenXdrDefinition;

public class JrpcgenContext
implements Closeable {
    private final JrpcgenXdrDefinition.Table globalDefinitions = new JrpcgenXdrDefinition.Table();
    private final Set<String> typesInFixedVectorUse = new HashSet<String>();
    private final Set<String> typesInDynamicVectorUse = new HashSet<String>();
    private final Set<String> predefinedTypes = new HashSet<String>();
    public File xFile = null;
    private final JrpcgenOptions options;
    private final FileInputStream xfileIn;
    public String currentFilename = null;
    private static final String NEWLINE = System.getProperty("line.separator");
    private final String jrpcgenVersion;

    public static String newline() {
        return NEWLINE;
    }

    public static JrpcgenContext open(JrpcgenOptions options, File xFile, String jrpcgenVersion) throws IOException {
        JrpcgenContext context = null;
        FileInputStream xfileIn = null;
        if (options.baseClassname == null) {
            String name = xFile.getName();
            int dotIdx = name.lastIndexOf(46);
            options.baseClassname = dotIdx < 0 ? name : name.substring(0, dotIdx);
        }
        try {
            xfileIn = new FileInputStream(xFile.getCanonicalPath());
            context = new JrpcgenContext(options, xFile, xfileIn, jrpcgenVersion);
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("jrpcgen: can not open source x-file \"" + xFile.getCanonicalPath() + "\"");
        }
        context.globalDefinitions.putItem(new JrpcgenConst(context, "TRUE", "true"));
        context.globalDefinitions.putItem(new JrpcgenConst(context, "FALSE", "false"));
        return context;
    }

    public static JrpcgenContext open(JrpcgenOptions options, String xfilename, String jrpcgenVersion) throws IOException {
        File xFile = xfilename.startsWith(File.separator) ? new File(xfilename) : new File(".", xfilename);
        return JrpcgenContext.open(options, xFile, jrpcgenVersion);
    }

    public final String getJrpcgenVersion() {
        return this.jrpcgenVersion;
    }

    public final JrpcgenOptions options() {
        return this.options;
    }

    public final JrpcgenXdrDefinition.Table globalDefinitions() {
        return this.globalDefinitions;
    }

    public final Set<String> typesInFixedVectorUse() {
        return this.typesInFixedVectorUse;
    }

    public final Set<String> typesInDynamicVectorUse() {
        return this.typesInDynamicVectorUse;
    }

    public final Set<String> predefinedTypes() {
        return this.predefinedTypes;
    }

    public String getInterfaceName(String programId) {
        return this.options.baseClassname + "_" + programId + "_CltIF";
    }

    public JrpcgenSHA createSHA(String classname) {
        String packageName = this.options.packageName;
        JrpcgenSHA hash = new JrpcgenSHA();
        if (packageName != null && packageName.length() > 0) {
            hash.update(packageName + "." + classname);
        } else {
            hash.update(classname);
        }
        return hash;
    }

    public void reset() {
        this.options.reset();
        this.globalDefinitions.clear();
        this.xFile = null;
        this.currentFilename = null;
    }

    @Override
    public void close() throws IOException {
        this.xfileIn.close();
    }

    private JrpcgenContext(JrpcgenOptions options, File xfile, FileInputStream xfileIn, String jrpcgenVersion) {
        this.options = options;
        this.xFile = xfile;
        this.xfileIn = xfileIn;
        this.jrpcgenVersion = jrpcgenVersion;
    }
}

