/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

import java.io.IOException;
import java.util.Objects;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenContext;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenItemTable;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenJavaFile;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenXdrDefinition;

public class JrpcgenConst
extends JrpcgenXdrDefinition {
    private final JrpcgenContext context;
    private String value;
    private String identifierValueStartsWith;
    private String trailingPartOfValue;
    private String enclosure;
    private boolean alreadyDeclared = false;

    public static String getAsRValue(String constantExpression, JrpcgenContext context) {
        return JrpcgenConst.getAsRValue(constantExpression, null, context);
    }

    public static String getAsRValue(String constantExpression, String forEnclosure, JrpcgenContext context) {
        JrpcgenConst constant;
        String rValue = constantExpression;
        if (JrpcgenConst.isLetter(constantExpression.charAt(0)) && (constant = context.globalDefinitions().getItem(JrpcgenConst.class, constantExpression)) != null) {
            rValue = constant.getAsRValue(forEnclosure);
        }
        return rValue;
    }

    public static String getAsCaseValue(String constantExpression, String forEnclosure, JrpcgenContext context) {
        JrpcgenConst constant;
        String caseValue = constantExpression;
        if (JrpcgenConst.isLetter(constantExpression.charAt(0)) && (constant = context.globalDefinitions().getItem(JrpcgenConst.class, constantExpression)) != null) {
            caseValue = constant.getAsCaseValue(forEnclosure);
        }
        return caseValue;
    }

    public JrpcgenConst(JrpcgenContext context, String identifier, String value) {
        this(context, identifier, value, null);
    }

    public JrpcgenConst(JrpcgenContext context, String identifier, String value, String enclosure) {
        super(identifier, JrpcgenXdrDefinition.Type.CONST);
        this.context = context;
        this.value = value;
        this.enclosure = enclosure;
    }

    public final JrpcgenContext getContext() {
        return this.context;
    }

    public final String getValue() {
        return this.value;
    }

    public final void setValue(String value) {
        this.value = value;
        this.identifierValueStartsWith = null;
        this.trailingPartOfValue = null;
    }

    public final String getEnclosure() {
        return this.enclosure;
    }

    public final void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    public String getForEnclosure(String forEnclosure) {
        if (this.enclosure == null) {
            return this.value;
        }
        if (this.enclosure.equals(forEnclosure)) {
            return this.getIdentifier();
        }
        return "" + this.enclosure + "." + this.getIdentifier();
    }

    public String getAsRValue(String forEnclosure) {
        if (this.enclosure == null) {
            return this.value;
        }
        if (this.enclosure.equals(forEnclosure)) {
            return this.getIdentifier();
        }
        return "" + this.enclosure + '.' + this.getIdentifier();
    }

    public String getAsCaseValue(String forEnclosure) {
        return this.getAsRValue(forEnclosure);
    }

    public String getValueAsRValue(String forEnclosure) {
        JrpcgenConst constant;
        if (this.enclosure == null) {
            return this.value;
        }
        String rValue = this.value;
        if (this.getIdentifierValueStartsWith() != null && (constant = this.context.globalDefinitions().getItem(JrpcgenConst.class, this.identifierValueStartsWith)) != null) {
            rValue = constant.getAsRValue(forEnclosure).concat(this.trailingPartOfValue);
        }
        return rValue;
    }

    public String resolveValue() {
        if (this.value.length() > 0) {
            if (Character.isDigit(this.value.charAt(0)) || this.value.charAt(0) == '-') {
                return this.value;
            }
            JrpcgenConst id = this.context.globalDefinitions().getItem(JrpcgenConst.class, this.value);
            if (id != null) {
                return id.resolveValue();
            }
        }
        return null;
    }

    public void writeDeclaration(JrpcgenJavaFile javaFile) {
        if (!this.alreadyDeclared) {
            JrpcgenConst constant;
            String valueToWrite = this.value;
            String dependency = JrpcgenConst.detectIdentifier(this.value);
            this.alreadyDeclared = true;
            if (dependency != null && (constant = this.context.globalDefinitions().getItem(JrpcgenConst.class, dependency)) != null) {
                if (Objects.equals(this.enclosure, constant.enclosure)) {
                    constant.writeDeclaration(javaFile);
                }
                valueToWrite = constant.getAsRValue(this.enclosure).concat(this.value.substring(dependency.length()));
            }
            this.writeDocumentation(javaFile);
            javaFile.newLine().beginLine().append("public static final int ").append(this.getIdentifier()).append(" = ").append(valueToWrite).println(';');
        }
    }

    public void dump() {
        System.out.print(JrpcgenXdrDefinition.Type.CONST.name().concat(" "));
        this.dump(System.out).println();
    }

    public <T extends Appendable> T dump(T appendable) {
        try {
            appendable.append(this.getIdentifier()).append('=').append(this.value);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return appendable;
    }

    public String toString() {
        return this.dump(new StringBuilder()).toString();
    }

    public static String detectIdentifier(String expression) {
        int identifierEnd;
        String identifier = null;
        if (expression != null && expression.length() > 0 && JrpcgenConst.isLetter(expression.charAt(identifierEnd = 0))) {
            int length = expression.length();
            for (identifierEnd = 1; identifierEnd < length && JrpcgenConst.isLetterOrDigitOrUnderbar(expression.charAt(identifierEnd)); ++identifierEnd) {
            }
            identifier = expression.substring(0, identifierEnd);
        }
        return identifier;
    }

    private static boolean isLetter(char character) {
        return character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z';
    }

    private static boolean isDigit(char character) {
        return character >= '0' && character <= '9';
    }

    private static boolean isLetterOrDigitOrUnderbar(char character) {
        return JrpcgenConst.isLetter(character) || JrpcgenConst.isDigit(character) || character == '_';
    }

    private String getIdentifierValueStartsWith() {
        if (this.identifierValueStartsWith == null && this.trailingPartOfValue == null) {
            this.identifierValueStartsWith = JrpcgenConst.detectIdentifier(this.value);
            this.trailingPartOfValue = this.identifierValueStartsWith == null ? this.value : this.value.substring(this.identifierValueStartsWith.length());
        }
        return this.identifierValueStartsWith;
    }

    public static class Table
    extends JrpcgenItemTable<JrpcgenConst> {
    }
}

