/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

import org.acplt.oncrpc.apps.jrpcgen.JrpcgenBaseType;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenContext;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenJavaFile;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenTypeMapping;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenXdrDefinition;

public abstract class JrpcgenComplexType
extends JrpcgenXdrDefinition
implements JrpcgenTypeMapping {
    public JrpcgenComplexType(String identifier, JrpcgenXdrDefinition.Type type) {
        super(identifier, type);
        assert (type != null && type != JrpcgenXdrDefinition.Type.CONST);
    }

    public abstract void generateJavaFile();

    @Override
    public final boolean isVoid() {
        return false;
    }

    @Override
    public final boolean isBaseType() {
        return false;
    }

    @Override
    public final boolean isBooleanType() {
        return false;
    }

    @Override
    public final boolean isStringType() {
        return false;
    }

    @Override
    public final boolean isOpaqueType() {
        return false;
    }

    @Override
    public String getDefinitionName() {
        return this.getIdentifier();
    }

    @Override
    public String getJavaName() {
        return this.getIdentifier();
    }

    @Override
    public String getJavaClass() {
        return this.getIdentifier();
    }

    @Override
    public String getXdrClass() {
        return this.getIdentifier();
    }

    @Override
    public void writeXdrConstructorCall(JrpcgenJavaFile javaFile, String parameter) {
        javaFile.keywordNew().space().append(this.getXdrClass()).leftParenthesis();
        if (parameter != null) {
            javaFile.append(parameter);
        }
        javaFile.rightParenthesis();
    }

    @Override
    public void writeXdrConstructorCall(JrpcgenJavaFile javaFile, JrpcgenJavaFile.Expression parameterExpression) {
        javaFile.keywordNew().space().append(this.getXdrClass()).leftParenthesis().expression(parameterExpression).rightParenthesis();
    }

    @Override
    public void writeJavaToXdr(JrpcgenJavaFile javaFile, String variable) {
        javaFile.append(variable);
    }

    @Override
    public void writeJavaToXdr(JrpcgenJavaFile javaFile, JrpcgenJavaFile.Expression expression) {
        expression.writeTo(javaFile);
    }

    @Override
    public void writeXdrToJava(JrpcgenJavaFile javaFile, String variable) {
        javaFile.append(variable);
    }

    @Override
    public void writeXdrEncodingCall(JrpcgenJavaFile javaFile, String xdrStream, String variable) {
        javaFile.append(variable).append(".xdrEncode(").append(xdrStream).rightParenthesis();
    }

    @Override
    public void writeXdrEncodingCall(JrpcgenJavaFile javaFile, String xdrStream, JrpcgenJavaFile.Expression expression) {
        javaFile.expression(expression).append(".xdrEncode(").append(xdrStream).rightParenthesis();
    }

    @Override
    public void writeXdrFixedVectorEncodingCall(JrpcgenJavaFile javaFile, String xdrStream, String variable, String size) {
        javaFile.append(this.getIdentifier()).dot().append("xdrEncodeFixedVector(").append(xdrStream).append(", ").append(variable).append(", ").append(size).rightParenthesis();
    }

    @Override
    public void writeXdrDynamicVectorEncodingCall(JrpcgenJavaFile javaFile, String xdrStream, String variable) {
        javaFile.append(this.getIdentifier()).dot().append("xdrEncodeDynamicVector(").append(xdrStream).append(", ").append(variable).rightParenthesis();
    }

    @Override
    public void writeXdrDecodingCall(JrpcgenJavaFile javaFile, String xdrStream) {
        javaFile.keywordNew().space().append(this.getJavaName()).leftParenthesis().append(xdrStream).rightParenthesis();
    }

    @Override
    public void writeXdrFixedVectorDecodingCall(JrpcgenJavaFile javaFile, String xdrStream, String size) {
        javaFile.append(this.getIdentifier()).dot().append("xdrDecodeFixedVector(").append(xdrStream).append(", ").append(size).rightParenthesis();
    }

    @Override
    public void writeXdrDynamicVectorDecodingCall(JrpcgenJavaFile javaFile, String xdrStream) {
        javaFile.append(this.getIdentifier()).dot().append("xdrDecodeDynamicVector(").append(xdrStream).rightParenthesis();
    }

    @Override
    public void writeEqualsExpression(JrpcgenJavaFile javaFile, String variableLeft, String variableRight, boolean negate) {
        javaFile.append(negate ? "! " : "").append("java.util.Objects.equals(").append(variableLeft).append(", ").append(variableRight).rightParenthesis();
    }

    public void writeXdrVectorCodingMethods(JrpcgenJavaFile javaFile, JrpcgenContext context) {
        boolean generateDynamicVectorCodingMethod = context.typesInDynamicVectorUse().contains(this.getIdentifier());
        if (generateDynamicVectorCodingMethod || context.typesInFixedVectorUse().contains(this.getIdentifier())) {
            javaFile.newLine().beginPublicMethod().staticMethod().resultType("void").name("xdrEncodeFixedVector").parameter("XdrEncodingStream", "xdr").parameter(this.getIdentifier().concat("[]"), "vector").parameter("int", "size").exceptions("OncRpcException", "IOException").endSignature().beginBlock().println("if (vector.length != size) {").beginLine().println("throw new IllegalArgumentException(\"array size does not match protocol specification\");").endBlock().println('}').newLine().beginBlock().println("for (int index = 0; index < size; index++) {").beginLine();
            this.writeXdrEncodingCall(javaFile, "xdr", "vector[index]");
            javaFile.semicolon().newLine().endBlock().println('}').endMethod();
            javaFile.newLine().beginPublicMethod().staticMethod().resultType(this.getIdentifier(), "[]").name("xdrDecodeFixedVector").parameter("XdrDecodingStream", "xdr").parameter("int", "size").exceptions("OncRpcException", "IOException").endSignature().beginLine().append(this.getIdentifier()).append("[] vector = new ").append(this.getIdentifier()).println("[size];").newLine().beginBlock().println("for (int index = 0; index < size; index++) {").beginLine().append("vector[index] = ");
            this.writeXdrDecodingCall(javaFile, "xdr");
            javaFile.semicolon().newLine().endBlock().println('}').newLine().beginLine().keywordReturn().space().append("vector").semicolon().newLine().endMethod();
            if (generateDynamicVectorCodingMethod) {
                javaFile.newLine().beginPublicMethod().staticMethod().resultType("void").name("xdrEncodeDynamicVector").parameter("XdrEncodingStream", "xdr").parameter(this.getIdentifier().concat("[]"), "vector").exceptions("OncRpcException", "IOException").endSignature().beginLine();
                JrpcgenBaseType.INT.writeXdrEncodingCall(javaFile, "xdr", "vector.length");
                javaFile.semicolon().beginNewLine().println("xdrEncodeFixedVector(xdr, vector, vector.length);").endMethod();
                javaFile.newLine().beginPublicMethod().staticMethod().resultType(this.getIdentifier(), "[]").name("xdrDecodeDynamicVector").parameter("XdrDecodingStream", "xdr").exceptions("OncRpcException", "IOException").endSignature().beginLine().keywordReturn().space().append("xdrDecodeFixedVector(xdr, ");
                JrpcgenBaseType.INT.writeXdrDecodingCall(javaFile, "xdr");
                javaFile.rightParenthesis().semicolon().newLine().endMethod();
            }
        }
    }
}

