/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

import org.acplt.oncrpc.apps.jrpcgen.JrpcgenJavaFile;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenTypeMapping;

public enum JrpcgenBaseType implements JrpcgenTypeMapping
{
    VOID("void", "XdrVoid"),
    BOOL("bool", "boolean", "XdrBoolean"),
    CHAR("char", "byte", "XdrByte"),
    SHORT("short", "XdrShort"),
    INT("int", "XdrInt"),
    HYPER("hyper", "long", "XdrLong"),
    FLOAT("float", "XdrFloat"),
    DOUBLE("double", "XdrDouble"),
    STRING("string", "String", "XdrString"),
    OPAQUE("opaque", "byte", "XdrOpaque");

    private final String definitionName;
    private final String javaName;
    private final String javaClass;
    private final String xdrClass;

    public static boolean isVoid(String type) {
        return JrpcgenBaseType.VOID.definitionName.equals(type);
    }

    public static boolean isBoolean(String type) {
        return JrpcgenBaseType.BOOL.definitionName.equals(type);
    }

    public static boolean isChar(String type) {
        return JrpcgenBaseType.CHAR.definitionName.equals(type);
    }

    public static boolean isShort(String type) {
        return JrpcgenBaseType.SHORT.definitionName.equals(type);
    }

    public static boolean isInt(String type) {
        return JrpcgenBaseType.INT.definitionName.equals(type);
    }

    public static boolean isHyper(String type) {
        return JrpcgenBaseType.HYPER.definitionName.equals(type);
    }

    public static boolean isFloat(String type) {
        return JrpcgenBaseType.FLOAT.definitionName.equals(type);
    }

    public static boolean isDouble(String type) {
        return JrpcgenBaseType.DOUBLE.definitionName.equals(type);
    }

    public static boolean isString(String type) {
        return JrpcgenBaseType.STRING.definitionName.equals(type);
    }

    public static boolean isOpaque(String type) {
        return JrpcgenBaseType.OPAQUE.definitionName.equals(type);
    }

    public static boolean isPrimitive(String type) {
        return JrpcgenBaseType.isBoolean(type) || JrpcgenBaseType.isChar(type) || JrpcgenBaseType.isShort(type) || JrpcgenBaseType.isInt(type) || JrpcgenBaseType.isHyper(type) || JrpcgenBaseType.isFloat(type) || JrpcgenBaseType.isDouble(type);
    }

    public static boolean isBaseType(String type) {
        return JrpcgenBaseType.isString(type) || JrpcgenBaseType.isPrimitive(type) || JrpcgenBaseType.isOpaque(type) || JrpcgenBaseType.isVoid(type);
    }

    public static JrpcgenBaseType getBaseType(String type) {
        if (JrpcgenBaseType.isVoid(type)) {
            return VOID;
        }
        if (JrpcgenBaseType.isBoolean(type)) {
            return BOOL;
        }
        if (JrpcgenBaseType.isChar(type)) {
            return CHAR;
        }
        if (JrpcgenBaseType.isShort(type)) {
            return SHORT;
        }
        if (JrpcgenBaseType.isInt(type)) {
            return INT;
        }
        if (JrpcgenBaseType.isHyper(type)) {
            return HYPER;
        }
        if (JrpcgenBaseType.isFloat(type)) {
            return FLOAT;
        }
        if (JrpcgenBaseType.isDouble(type)) {
            return DOUBLE;
        }
        if (JrpcgenBaseType.isString(type)) {
            return STRING;
        }
        if (JrpcgenBaseType.isOpaque(type)) {
            return OPAQUE;
        }
        return null;
    }

    @Override
    public final boolean isVoid() {
        return VOID.equals(this);
    }

    @Override
    public final boolean isBaseType() {
        return true;
    }

    @Override
    public final boolean isBooleanType() {
        return BOOL.equals(this);
    }

    @Override
    public final boolean isStringType() {
        return STRING.equals(this);
    }

    @Override
    public final boolean isOpaqueType() {
        return OPAQUE.equals(this);
    }

    @Override
    public final String getDefinitionName() {
        return this.definitionName;
    }

    @Override
    public final String getJavaName() {
        return this.javaName;
    }

    @Override
    public final String getJavaClass() {
        return this.javaClass;
    }

    @Override
    public final String getXdrClass() {
        return this.xdrClass;
    }

    @Override
    public void writeXdrConstructorCall(JrpcgenJavaFile javaFile, String parameter) {
        switch (this) {
            case VOID: {
                javaFile.append("XdrVoid.XDR_VOID");
                break;
            }
            default: {
                javaFile.keywordNew().space().append(this.getXdrClass()).leftParenthesis();
                if (parameter != null) {
                    javaFile.append(parameter);
                }
                javaFile.rightParenthesis();
            }
        }
    }

    @Override
    public void writeXdrConstructorCall(JrpcgenJavaFile javaFile, JrpcgenJavaFile.Expression parameterExpression) {
        switch (this) {
            case VOID: {
                javaFile.append("XdrVoid.XDR_VOID");
                break;
            }
            default: {
                javaFile.keywordNew().space().append(this.getXdrClass()).leftParenthesis().expression(parameterExpression).rightParenthesis();
            }
        }
    }

    @Override
    public void writeJavaToXdr(JrpcgenJavaFile javaFile, String variable) {
        this.writeXdrConstructorCall(javaFile, variable);
    }

    @Override
    public void writeJavaToXdr(JrpcgenJavaFile javaFile, JrpcgenJavaFile.Expression expression) {
        this.writeXdrConstructorCall(javaFile, expression);
    }

    @Override
    public void writeXdrToJava(JrpcgenJavaFile javaFile, String result) {
        switch (this) {
            case VOID: {
                break;
            }
            case STRING: {
                javaFile.append(result).append(".stringValue()");
                break;
            }
            case OPAQUE: {
                javaFile.append(result).append(".opaqueValue()");
                break;
            }
            default: {
                javaFile.append(result).dot().append(this.getJavaName()).append("Value()");
            }
        }
    }

    @Override
    public void writeXdrEncodingCall(JrpcgenJavaFile javaFile, String xdrStream, String variable) {
        switch (this) {
            case VOID: 
            case STRING: 
            case OPAQUE: {
                break;
            }
            default: {
                this.writeCodingMethodStem(javaFile, xdrStream, "xdrEncode", this.javaName).append('(').append(variable).rightParenthesis();
            }
        }
    }

    @Override
    public void writeXdrEncodingCall(JrpcgenJavaFile javaFile, String xdrStream, JrpcgenJavaFile.Expression expression) {
        switch (this) {
            case VOID: 
            case STRING: 
            case OPAQUE: {
                break;
            }
            default: {
                this.writeCodingMethodStem(javaFile, xdrStream, "xdrEncode", this.javaName).append('(').expression(expression).rightParenthesis();
            }
        }
    }

    @Override
    public void writeXdrFixedVectorEncodingCall(JrpcgenJavaFile javaFile, String xdrStream, String variable, String size) {
        switch (this) {
            case VOID: 
            case STRING: {
                break;
            }
            case OPAQUE: {
                this.writeCodingMethodStem(javaFile, xdrStream, "xdrEncode", this.definitionName).leftParenthesis().append(variable).append(", ").append(size).rightParenthesis();
                break;
            }
            default: {
                this.writeCodingMethodStem(javaFile, xdrStream, "xdrEncode", this.javaName).append("FixedVector(").append(variable).append(", ").append(size).rightParenthesis();
            }
        }
    }

    @Override
    public void writeXdrDynamicVectorEncodingCall(JrpcgenJavaFile javaFile, String xdrStream, String variable) {
        switch (this) {
            case VOID: {
                break;
            }
            case STRING: {
                this.writeCodingMethodStem(javaFile, xdrStream, "xdrEncode", this.javaName).append('(').append(variable).rightParenthesis();
                break;
            }
            case OPAQUE: {
                this.writeCodingMethodStem(javaFile, xdrStream, "xdrEncodeDynamic", this.definitionName).leftParenthesis().append(variable).rightParenthesis();
                break;
            }
            default: {
                this.writeCodingMethodStem(javaFile, xdrStream, "xdrEncode", this.javaName).append("Vector(").append(variable).rightParenthesis();
            }
        }
    }

    @Override
    public void writeXdrDecodingCall(JrpcgenJavaFile javaFile, String xdrStream) {
        switch (this) {
            case VOID: 
            case STRING: 
            case OPAQUE: {
                break;
            }
            default: {
                this.writeCodingMethodStem(javaFile, xdrStream, "xdrDecode", this.javaName).append("()");
            }
        }
    }

    @Override
    public void writeXdrFixedVectorDecodingCall(JrpcgenJavaFile javaFile, String xdrStream, String size) {
        switch (this) {
            case VOID: 
            case STRING: {
                break;
            }
            case OPAQUE: {
                this.writeCodingMethodStem(javaFile, xdrStream, "xdrDecode", this.definitionName).leftParenthesis().append(size).rightParenthesis();
                break;
            }
            default: {
                this.writeCodingMethodStem(javaFile, xdrStream, "xdrDecode", this.javaName).append("FixedVector(").append(size).rightParenthesis();
            }
        }
    }

    @Override
    public void writeXdrDynamicVectorDecodingCall(JrpcgenJavaFile javaFile, String xdrStream) {
        switch (this) {
            case VOID: {
                break;
            }
            case STRING: {
                this.writeCodingMethodStem(javaFile, xdrStream, "xdrDecode", this.javaName).append("()");
                break;
            }
            case OPAQUE: {
                this.writeCodingMethodStem(javaFile, xdrStream, "xdrDecodeDynamic", this.definitionName).append("()");
                break;
            }
            default: {
                this.writeCodingMethodStem(javaFile, xdrStream, "xdrDecode", this.javaName).append("Vector()");
            }
        }
    }

    @Override
    public void writeEqualsExpression(JrpcgenJavaFile javaFile, String variableLeft, String variableRight, boolean negate) {
        switch (this) {
            case VOID: {
                break;
            }
            case STRING: {
                javaFile.append(negate ? "! " : "").append("java.util.Objects.equals(").append(variableLeft).append(", ").append(variableRight).rightParenthesis();
                break;
            }
            default: {
                javaFile.append(variableLeft).append(negate ? " != " : " == ").append(variableRight);
            }
        }
    }

    public JrpcgenJavaFile writeCodingMethodStem(JrpcgenJavaFile javaFile, String xdrStream, String codingType, String typeSpecifier) {
        return javaFile.append(xdrStream).dot().append(codingType).append(typeSpecifier.substring(0, 1).toUpperCase()).append(typeSpecifier.substring(1));
    }

    private JrpcgenBaseType(String definitionName, String xdrClass) {
        this.definitionName = definitionName;
        this.javaName = definitionName;
        this.javaClass = JrpcgenBaseType.getJavaClassTo(definitionName);
        this.xdrClass = xdrClass;
    }

    private JrpcgenBaseType(String definitionName, String javaName, String xdrClass) {
        this.definitionName = definitionName;
        this.javaName = javaName;
        this.javaClass = JrpcgenBaseType.getJavaClassTo(javaName);
        this.xdrClass = xdrClass;
    }

    private static String getJavaClassTo(String javaName) {
        switch (javaName) {
            case "int": {
                return "Integer";
            }
            case "String": {
                return javaName;
            }
        }
        return javaName.substring(0, 1).toUpperCase().concat(javaName.substring(1));
    }
}

