/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.ant;

import java.io.File;
import java.io.IOException;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenContext;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenOptions;
import org.acplt.oncrpc.apps.jrpcgen.jrpcgen;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class JrpcgenTask
extends Task {
    private File srcFile;
    private File destDir;
    private boolean createDir = false;
    private final JrpcgenOptions options = new JrpcgenOptions();

    public void setSrcfile(File srcFile) {
        this.srcFile = srcFile;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public void setPackage(String packageName) {
        this.options.packageName = packageName;
    }

    public void setCreatedir(boolean createDir) {
        this.createDir = createDir;
    }

    public void setDebug(boolean debug) {
        this.options.debug = debug;
    }

    public void setVerbose(boolean verbose) {
        this.options.verbose = verbose;
    }

    public void setBackup(boolean backup) {
        this.options.noBackups = !backup;
    }

    public void setNoClient(boolean noClient) {
        this.options.noClient = noClient;
    }

    public void setNoServer(boolean noServer) {
        this.options.noServer = noServer;
    }

    public void setNoXdr(boolean noXdr) {
        this.options.noXdr = noXdr;
    }

    public void setServerTcpOnly(boolean serverTcpOnly) {
        this.options.serverTcpOnly = serverTcpOnly;
    }

    public void setServerUdpOnly(boolean serverUdpOnly) {
        this.options.serverUdpOnly = serverUdpOnly;
    }

    public void setBean(boolean bean) {
        if (bean) {
            this.options.makeSerializable = bean;
        }
        this.options.makeBean = bean;
    }

    public void setSerializable(boolean serializable) {
        if (!this.options.makeBean) {
            this.options.makeSerializable = serializable;
        }
    }

    public void setNoValueCtor(boolean noValueCtor) {
        this.options.noValueCtor = noValueCtor;
    }

    public void setNoToString(boolean noToString) {
        this.options.noToString = noToString;
    }

    public void setNoEquals(boolean noEquals) {
        this.options.noEquals = noEquals;
    }

    public void setNoEnum(boolean noEnum) {
        this.options.noEnum = noEnum;
    }

    public void setInitStrings(boolean initStrings) {
        this.options.initStrings = initStrings;
    }

    public void setNoClamp(boolean noClamp) {
        this.options.clampProgAndVers = !noClamp;
    }

    public void setWithCallInfo(boolean withCallInfo) {
        this.options.withCallInfo = withCallInfo;
    }

    public void execute() throws BuildException {
        this.checkAttributes();
        try {
            this.log("Compiling " + this.srcFile.getCanonicalPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.options.packageName != null) {
            try {
                this.destDir = new File(this.destDir.getCanonicalPath() + File.separator + this.options.packageName.replace('.', File.separatorChar));
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
        }
        if (this.createDir) {
            try {
                boolean dirsCreated;
                if (!this.destDir.exists() && !(dirsCreated = this.destDir.mkdirs())) {
                    throw new BuildException("Could not create destination dir");
                }
            }
            catch (SecurityException ex) {
                throw new BuildException((Throwable)ex);
            }
        }
        if (this.options.debug) {
            this.dumpState();
        }
        this.options.destinationDir = this.destDir;
        try (JrpcgenContext context = JrpcgenContext.open(this.options, this.srcFile, "1.1.6");){
            new jrpcgen(context).doParse().generateJavaFiles();
        }
        catch (Throwable t) {
            throw new BuildException(t);
        }
    }

    private void checkAttributes() throws BuildException {
        if (this.srcFile == null) {
            throw new BuildException("srcfile has not been set");
        }
        if (this.destDir == null) {
            throw new BuildException("destdir has not been set");
        }
        try {
            if (!this.srcFile.isFile()) {
                throw new BuildException("problem reading srcdir");
            }
            if (!this.destDir.isDirectory()) {
                throw new BuildException("problem accessing srcdir");
            }
        }
        catch (SecurityException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void dumpState() {
        System.out.println(this.srcFile);
        System.out.println(this.destDir);
        System.out.println(this.createDir);
        System.out.println(this.options);
    }
}

